package jp.sourceforge.cfneo.at4ie.utils;

import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;

import org.apache.log4j.Logger;

/**
 * p[eBeBB<br />
 * @author imaitakafumi
 *
 */
public class AT4IEStringUtil {

	static Logger logger = Logger.getLogger(AT4IEStringUtil.class);

	/**
	 * w肵񂪐lō\Ă邩ǂ𔻒肷B
	 * @param value
	 * @return
	 */
	public static boolean isNumeric(String value) {
		if (value == null || value.trim().length() == 0) {
			return false;
		}
		if (isInteger(value) || isFloat(value)) {
			return true;
		}
		return false;
	}

	/**
	 * w肵񂪐(int/long)ǂ𔻒肷B
	 * @param value
	 * @return
	 */
	public static boolean isInteger(String value) {
		try {
			Long.valueOf(value);
		} catch (NumberFormatException e) {
			return false;
		}
		return true;
	}

	/**
	 * w肵񂪕_(float/double)ǂ𔻒肷B
	 * @param value
	 * @return
	 */
	public static boolean isFloat(String value) {
		if (value == null) {
			return false;
		}
		try {
			Double.parseDouble(value);
		} catch (NumberFormatException e) {
			return false;
		}
		return true;
	}
	/**
	 * w肵񂪎ԕ\L(xx:xx/xx:xx:xx)ǂ𔻒肷B
	 * @param value
	 * @return
	 */
	public static boolean isTimeFormat(String value) {
		logger.debug("AT4IEStringUtil#isTimeFormat value=[" + value + "]");
		if (value == null || value.trim().length() == 0) {
			return false;
		}
		String[] values = value.split(":");
		if ((values.length <= 1) || (values.length > 3)) {
			return false;
		}
		Long h, m, s;
		logger.debug("AT4IEStringUtil#isTimeFormat values.length=" + values.length);
		if (values.length >= 2) {
			// minute
			if (isInteger(values[values.length - 2]) == false) {
				return false;
			}
			m = new Long(values[values.length - 2]);
			logger.debug("AT4IEStringUtil#isTimeFormat m=" + m);
			if (m.longValue() >= 60 || m.longValue() < 0) {
				return false;
			}
			// second
			if (isInteger(values[values.length - 1]) == false) {
				return false;
			}
			s = new Long(values[values.length - 1]);
			logger.debug("AT4IEStringUtil#isTimeFormat s=" + s);
			if (s.longValue() >= 60 || s.longValue() < 0) {
				return false;
			}
		}
		if (values.length == 3) {
			// hour
			if (isInteger(values[values.length - 3]) == false) {
				return false;
			}
			h = new Long(values[values.length - 3]);
			logger.debug("AT4IEStringUtil#isTimeFormat h=" + h);
			if (h.longValue() >= 24 || h.longValue() < 0) {
				return false;
			}
		}
		return true;
	}
	/**
	 * ԕ\L(xx:xx/xx:xx:xx)̕SĕbɕϊB
	 * @param value
	 * @return
	 */
	public static long getLongValueFromTimeFormat(String value) {
		logger.debug("AT4IEStringUtil#getLongValueFromTimeFormat value=[" + value + "]");
		if (isTimeFormat(value) == false) {
			throw new AT4IERuntimeException("Value is not Time format string.");
		}
		return new AT4IETimeFormat(value).getSecondValue();
	}

}
