package jp.sourceforge.cfneo.at4ie.utils;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;

import org.junit.Test;

/**
 * AT4IEStringUtil̃eXgB
 * @author imaitakafumi
 *
 */
public class AT4IEStringUtilTest {

	/**
	 * ʂ̐lB
	 */
	@Test
	public void testIsNumeric_1() {
		assertTrue(AT4IEStringUtil.isNumeric("12345"));
	}
	/**
	 * _B
	 */
	@Test
	public void testIsNumeric_2() {
		assertTrue(AT4IEStringUtil.isNumeric("1234.5"));
	}
	/**
	 * [߂ꂽlB
	 */
	@Test
	public void testIsNumeric_3() {
		assertTrue(AT4IEStringUtil.isNumeric("012345"));
	}
	/**
	 * Double.MAX_VALUE
	 */
	@Test
	public void testIsNumeric_4() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MAX_VALUE)));
	}
	/**
	 * Double.MAX_EXPONENT
	 */
	@Test
	public void testIsNumeric_5() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MAX_EXPONENT)));
	}
	/**
	 * Double.MIN_VALUE
	 */
	@Test
	public void testIsNumeric_6() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MIN_VALUE)));
	}
	/**
	 * Double.MIN_EXPONENT
	 */
	@Test
	public void testIsNumeric_7() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MIN_EXPONENT)));
	}
	/**
	 * Double.MIN_NORMAL
	 */
	@Test
	public void testIsNumeric_8() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MIN_NORMAL)));
	}
	/**
	 * B
	 */
	@Test
	public void testIsNumeric_9() {
		assertFalse(AT4IEStringUtil.isNumeric("50.0.0"));
	}
	/**
	 * B
	 */
	@Test
	public void testIsNumeric_10() {
		assertFalse(AT4IEStringUtil.isNumeric("abcde"));
	}
	/**
	 * B
	 */
	@Test
	public void testIsNumeric_11() {
		assertFalse(AT4IEStringUtil.isNumeric("0x12"));
	}
	/**
	 * 󕶎B
	 */
	@Test
	public void testIsNumeric_12() {
		assertFalse(AT4IEStringUtil.isNumeric(""));
	}
	/**
	 * nullB
	 */
	@Test
	public void testIsNumeric_13() {
		assertFalse(AT4IEStringUtil.isNumeric(null));
	}

	/**
	 * B
	 */
	@Test
	public void testIsInteger_1() {
		assertTrue(AT4IEStringUtil.isInteger("123"));
	}
	/**
	 * 0~B
	 */
	@Test
	public void testIsInteger_2() {
		assertTrue(AT4IEStringUtil.isInteger("0123"));
	}
	/**
	 * s_B
	 */
	@Test
	public void testIsInteger_3() {
		assertFalse(AT4IEStringUtil.isInteger("123.4"));
	}
	/**
	 * B
	 */
	@Test
	public void testIsInteger_4() {
		assertFalse(AT4IEStringUtil.isInteger("123.4.5"));
	}
	/**
	 * B
	 */
	@Test
	public void testIsInteger_5() {
		assertFalse(AT4IEStringUtil.isInteger("0x12"));
	}

	/**
	 * ʂ̐lB
	 */
	@Test
	public void testIsFloat_1() {
		assertTrue(AT4IEStringUtil.isNumeric("12345"));
	}
	/**
	 * _B
	 */
	@Test
	public void testIsFloat_2() {
		assertTrue(AT4IEStringUtil.isNumeric("1234.5"));
	}
	/**
	 * [߂ꂽlB
	 */
	@Test
	public void testIsFloat_3() {
		assertTrue(AT4IEStringUtil.isNumeric("012345"));
	}
	/**
	 * Double.MAX_VALUE
	 */
	@Test
	public void testIsFloat_4() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MAX_VALUE)));
	}
	/**
	 * Double.MAX_EXPONENT
	 */
	@Test
	public void testIsFloat_5() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MAX_EXPONENT)));
	}
	/**
	 * Double.MIN_VALUE
	 */
	@Test
	public void testIsFloat_6() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MIN_VALUE)));
	}
	/**
	 * Double.MIN_EXPONENT
	 */
	@Test
	public void testIsFloat_7() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MIN_EXPONENT)));
	}
	/**
	 * Double.MIN_NORMAL
	 */
	@Test
	public void testIsFloat_8() {
		assertTrue(AT4IEStringUtil.isNumeric(String.valueOf(Double.MIN_NORMAL)));
	}
	/**
	 * B
	 */
	@Test
	public void testIsFloat_9() {
		assertFalse(AT4IEStringUtil.isNumeric("50.0.0"));
	}
	/**
	 * B
	 */
	@Test
	public void testIsFloat_10() {
		assertFalse(AT4IEStringUtil.isNumeric("abcde"));
	}
	/**
	 * B
	 */
	@Test
	public void testIsFloat_11() {
		assertFalse(AT4IEStringUtil.isNumeric("0x12"));
	}

	/**
	 * xx:xx0B
	 */
	@Test
	public void testIsTimeFormat_1() {
		assertTrue(AT4IEStringUtil.isTimeFormat("0:0"));
	}
	/**
	 * xx:xxminute̒lOverB
	 */
	@Test
	public void testIsTimeFormat_2() {
		assertFalse(AT4IEStringUtil.isTimeFormat("60:0"));
	}
	/**
	 * xx:xxminute̒lOverB
	 */
	@Test
	public void testIsTimeFormat_3() {
		assertFalse(AT4IEStringUtil.isTimeFormat("61:0"));
	}
	/**
	 * xx:xxsecond̒lOverB
	 */
	@Test
	public void testIsTimeFormat_5() {
		assertFalse(AT4IEStringUtil.isTimeFormat("59:60"));
	}
	/**
	 * xx:xxminute̒lOverB
	 */
	@Test
	public void testIsTimeFormat_6() {
		assertFalse(AT4IEStringUtil.isTimeFormat("61:61"));
	}
	/**
	 * xx:xxMax̒lB
	 */
	@Test
	public void testIsTimeFormat_7() {
		assertTrue(AT4IEStringUtil.isTimeFormat("59:59"));
	}
	/**
	 * xx:xx:xx0B
	 */
	@Test
	public void testIsTimeFormat_8() {
		assertTrue(AT4IEStringUtil.isTimeFormat("0:0:0"));
	}
	/**
	 * xx:xx:xxhour̒lOverB
	 */
	@Test
	public void testIsTimeFormat_9() {
		assertFalse(AT4IEStringUtil.isTimeFormat("24:0:0"));
	}
	/**
	 * xx:xx:xxhour̒lOverB
	 */
	@Test
	public void testIsTimeFormat_10() {
		assertFalse(AT4IEStringUtil.isTimeFormat("25:0:0"));
	}
	/**
	 * xx:xx:xxminute̒lOverB
	 */
	@Test
	public void testIsTimeFormat_11() {
		assertFalse(AT4IEStringUtil.isTimeFormat("23:60:0"));
	}
	/**
	 * xx:xx:xxminute̒lOverB
	 */
	@Test
	public void testIsTimeFormat_12() {
		assertFalse(AT4IEStringUtil.isTimeFormat("23:61:0"));
	}
	/**
	 * xx:xx:xxsecond̒lOverB
	 */
	@Test
	public void testIsTimeFormat_13() {
		assertFalse(AT4IEStringUtil.isTimeFormat("23:59:60"));
	}
	/**
	 * xx:xx:xxsecond̒lOverB
	 */
	@Test
	public void testIsTimeFormat_14() {
		assertFalse(AT4IEStringUtil.isTimeFormat("23:59:61"));
	}
	/**
	 * xx:xx:xxőSĂ̒lOverB
	 */
	@Test
	public void testIsTimeFormat_15() {
		assertFalse(AT4IEStringUtil.isTimeFormat("24:60:60"));
	}
	/**
	 * xx:xx:xxMax̒lB
	 */
	@Test
	public void testIsTimeFormat_16() {
		assertTrue(AT4IEStringUtil.isTimeFormat("23:59:59"));
	}
	/**
	 * xx:xxminuteɃ}CiXB
	 */
	@Test
	public void testIsTimeFormat_17() {
		assertFalse(AT4IEStringUtil.isTimeFormat("-1:0"));
	}
	/**
	 * xx:xxsecondɃ}CiXB
	 */
	@Test
	public void testIsTimeFormat_18() {
		assertFalse(AT4IEStringUtil.isTimeFormat("0:-1"));
	}
	/**
	 * xx:xxőSă}CiXB
	 */
	@Test
	public void testIsTimeFormat_19() {
		assertFalse(AT4IEStringUtil.isTimeFormat("-1:-1"));
	}
	/**
	 * xx:xx:xxhourɃ}CiXB
	 */
	@Test
	public void testIsTimeFormat_20() {
		assertFalse(AT4IEStringUtil.isTimeFormat("-1:0:0"));
	}
	/**
	 * xx:xx:xxminuteɃ}CiXB
	 */
	@Test
	public void testIsTimeFormat_21() {
		assertFalse(AT4IEStringUtil.isTimeFormat("0:-1:0"));
	}
	/**
	 * xx:xx:xxsecondɃ}CiXB
	 */
	@Test
	public void testIsTimeFormat_22() {
		assertFalse(AT4IEStringUtil.isTimeFormat("0:0:-1"));
	}
	/**
	 * xx:xx:xxőSă}CiXB
	 */
	@Test
	public void testIsTimeFormat_23() {
		assertFalse(AT4IEStringUtil.isTimeFormat("-1:-1:-1"));
	}

	/**
	 * xx:xx1bB
	 */
	@Test
	public void testGetLongValueFromTimeFormat_1() {
		assertEquals(1, AT4IEStringUtil.getLongValueFromTimeFormat("0:1"));
	}
	/**
	 * xx:xx1B
	 */
	@Test
	public void testGetLongValueFromTimeFormat_2() {
		assertEquals(60, AT4IEStringUtil.getLongValueFromTimeFormat("1:0"));
	}
	/**
	 * xx:xx:xx1bB
	 */
	@Test
	public void testGetLongValueFromTimeFormat_3() {
		assertEquals(1, AT4IEStringUtil.getLongValueFromTimeFormat("0:0:1"));
	}
	/**
	 * xx:xx:xx1B
	 */
	@Test
	public void testGetLongValueFromTimeFormat_4() {
		assertEquals(60, AT4IEStringUtil.getLongValueFromTimeFormat("0:1:0"));
	}
	/**
	 * xx:xx:xx1ԁB
	 */
	@Test
	public void testGetLongValueFromTimeFormat_5() {
		assertEquals(86400, AT4IEStringUtil.getLongValueFromTimeFormat("1:0:0"));
	}
	/**
	 * B
	 */
	@Test
	public void testGetLongValueFromTimeFormat_6() {
		try {
			AT4IEStringUtil.getLongValueFromTimeFormat("");
			fail();
		} catch (AT4IERuntimeException e) {
			;
		}
	}
	/**
	 * lB
	 */
	@Test
	public void testGetLongValueFromTimeFormat_7() {
		try {
			AT4IEStringUtil.getLongValueFromTimeFormat("8");
			fail();
		} catch (AT4IERuntimeException e) {
			;
		}
	}
	/**
	 * 󕶎B
	 */
	@Test
	public void testGetLongValueFromTimeFormat_8() {
		try {
			AT4IEStringUtil.getLongValueFromTimeFormat("");
			fail();
		} catch (AT4IERuntimeException e) {
			;
		}
	}
	/**
	 * nullB
	 */
	@Test
	public void testGetLongValueFromTimeFormat_9() {
		try {
			AT4IEStringUtil.getLongValueFromTimeFormat(null);
			fail();
		} catch (AT4IERuntimeException e) {
			;
		}
	}

}
