package misc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import watij.dialogs.AlertDialog;
import watij.elements.Button;
import watij.elements.Buttons;
import watij.runtime.ie.IE;

public class WatijTest2 {

	IE ie;

	@Before
	public void before() {
		this.ie = new IE();
	}
	@After
	public void after() {
		try {
			this.ie.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void test() {
		try {
			this.ie.start("http://www.scollabo.com/banban/jsindex/sample/sample_004.html");
			assertEquals("alert/JavaScriptt@X", ie.title());
			Buttons buttons = null;
			buttons = this.ie.buttons();
			Button button = null;
			for (Button b: buttons) {
				if (b.value().equals("Push!")) {
					button = b;
					break;
				}
			}
			Thread t = new Thread(new ButtonClicker(button));
			t.start();
			Thread.sleep(500L);
			t = null;
			AlertDialog ad = this.ie.alertDialog();
			assertEquals("{^܂", ad.text());
			ad.ok();
			this.ie.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	class ButtonClicker implements Runnable {
		private Button button;
		public ButtonClicker(Button button) {
			this.button = button;
		}
		public void run() {
			try {
				this.button.click();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
