package misc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.AT4IEButton;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.ButtonClicker;

import org.junit.Test;

import watij.finders.SymbolFactory;
import watij.runtime.ie.IE;

public class WatijTest4 extends AbstractTestCase {

	@Test
	public void test_1_confirmOK() {
		try {
			this.ie.start(TEST_PAGE);
			Thread t = new Thread(
					new ButtonClicker(
							new AT4IEButton(
									this.ie.button(SymbolFactory.id, "btn2"),
									this.ie)));
			t.start();
			Thread.sleep(500L);
			t = null;
			System.out.println(this.ie.confirmDialog().title());
			System.out.println(this.ie.confirmDialog().text());
			this.ie.confirmDialog().ok();
			assertEquals("yes", this.ie.textField(SymbolFactory.id, "txt1").value());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_2_confirmCancel() {
		class Clicker implements Runnable {
			IE ie;
			public Clicker(IE ie) {
				this.ie = ie;
			}
			public void run() {
				try {
					this.ie.button(SymbolFactory.id, "btn2").click();
				} catch (Exception e) {
					;
				}
			}
		}
		try {
			this.ie.start(TEST_PAGE);
			Thread t = new Thread(new Clicker(this.ie));
			t.start();
			Thread.sleep(500L);
			t = null;
			Thread.sleep(4000L);
			this.ie.confirmDialog().cancel();
//			this.ie.sendKeys(this.ie.confirmDialog().title(), "	 ");
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

}
