package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import java.lang.reflect.Constructor;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.InvokerFactory;
import jp.sourceforge.cfneo.at4ie2.api.test.TesterMap;

public class DefaultInvokerFactory implements InvokerFactory {

	Context context;
	TesterMap invokerMap;

	public DefaultInvokerFactory(Context context) {
		this.context = context;
		this.invokerMap = DefaultInvokerMap.getInstance();
	}

	@Override
	public CommandInvoker getInvoker(CommandEnum command) {
		try {
			Class<? extends CommandInvoker> c = this.invokerMap.getInvokerClass(command);
			Class<?>[] classArray = {Context.class};
			Constructor<? extends CommandInvoker> constructor = c.getConstructor(classArray);
			Object[] objects = {this.context};
			return constructor.newInstance(objects);
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
