package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import java.util.List;

import jp.sourceforge.cfneo.at4ie2.api.browser.Option;
import jp.sourceforge.cfneo.at4ie2.api.browser.Select;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.utils.BrowserUtil;
import jp.sourceforge.cfneo.at4ie2.utils.StringUtil;

public class AssertSelectOptionsInvoker extends AbstractInvoker {

	public AssertSelectOptionsInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		String[] expected = StringUtil.splitComma(testCase.getValue());

		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		Select select = null;
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			select = this.getBrowser().getSelect(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			select = this.getBrowser().getSelect(testCase.getTarget().getValue());
			if (select.exists() == false) {
				select = this.getBrowser().getSelectByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			select = this.getBrowser().getSelectByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		List<Option> optionList = select.getOptionList();
		if (expected.length != optionList.size()) {
			throw new BTAssertException(expected.length, optionList.size());
		}
		for (String st: expected) {
			boolean b = false;
			for (Option o: optionList) {
				if (st.equals(o.getLabel())) {
					b = true;
					break;
				}
			}
			if (b == false) {
				throw new BTAssertException(expected, BrowserUtil.createLabelList(optionList));
			}
		}
	}

}
