package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.Select;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.utils.StringUtil;

public class AssertSelectedInvoker extends AbstractInvoker {

	public AssertSelectedInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		String expected = testCase.getValue();
		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		Select select = null;
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			select = this.getBrowser().getSelect(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			select = this.getBrowser().getSelect(testCase.getTarget().getValue());
			if (select.exists() == false) {
				select = this.getBrowser().getSelectByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			select = this.getBrowser().getSelectByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		String actual = null;
		LocatorTypeEnum valueLocator = StringUtil.getLocatorType(testCase.getValue());
		if (LocatorTypeEnum.VALUE == valueLocator) {
			actual = StringUtil.getLocatorValue(testCase.getValue());
		} else {
			actual = select.getSelectedOption().getValue();
		}
		if (expected.equals(actual) == false) {
			throw new BTAssertException(expected, actual);
		}
	}

}
