package jp.sourceforge.cfneo.at4ie2.utils;

import org.apache.log4j.Logger;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseList;

public class TestUtil {

	static Logger logger = Logger.getLogger(TestUtil.class);

	public static TestCaseList appendTestCase(
			Context context, TestCaseList testCaseList, int id, String line) {
		String[] items = line.split(",");
		logger.debug("TestUtil#appendTestCase() id=" + id
				+ " line=[" + line + "] items.length=" + items.length);
		if (items.length == 0) {
			throw new BTRuntimeError("Illegal TestCase format =[" + line + "]");
		}
		CommandEnum command = CommandEnum.DUMMY;
		if (items.length >= 1) {
			command = CommandEnum.get(items[0]);
		}
		String target = null;
		if (items.length >= 2) {
			target = items[1];
		}
		String value = null;
		if (items.length >= 3) {
			value = items[2];
		}
		testCaseList.addTestCase(id, command, target, value);
		return testCaseList;
	}

}
