package misc;

import static org.junit.Assert.fail;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import jp.sourceforge.cfneo.at4ie2.TestSupport;

import org.junit.Test;

import watij.finders.SymbolFactory;
import watij.runtime.ie.IE;

public class WatijTest4 {

	@Test
	public void test_1() {
		try {
			final IE ie = new IE();
			ie.start(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

			Thread t1 = new Thread(new Clicker(ie));
			Thread t2 = new Thread(new Sender(ie, "{ENTER}"));

			t1.start();
			System.out.println("[" + getNow() + "]Thread-1:start");
			Thread.sleep(2000L);
			System.out.println("[" + getNow() + "]1bҋ@-1");
			t1 = null;
			System.out.println("[" + getNow() + "]Thread-1:killed");
//			t1.join();
//			System.out.println("Thread-1:join");

			Thread.sleep(2000L);
			System.out.println("[" + getNow() + "]2bҋ@-2");

			t2.start();
			System.out.println("[" + getNow() + "]Thread-2:start");
			Thread.sleep(1000L);
			System.out.println("[" + getNow() + "]1bҋ@-3");
			t2 = null;
			System.out.println("[" + getNow() + "]Thread-2:killed");
//			t2.join();
//			System.out.println("Thread-2:join");

			Thread.sleep(1000L);
			System.out.println("[" + getNow() + "]2bҋ@-4");

			ie.close();
			System.out.println("[" + getNow() + "]Browser closed.");
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		System.out.println("[" + getNow() + "]");
	}
	class Clicker implements Runnable {
		IE ie;
		public Clicker(IE ie) {
			this.ie = ie;
		}
		public void run() {
			try {
				ie.button(SymbolFactory.id, "btn2").click();
				System.out.println("[" + getNow() + "]Button clicked");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	class Sender implements Runnable {
		IE ie;
		String key;
		public Sender(IE ie, String key) {
			this.ie = ie;
			this.key = key;
		}
		public void run() {
			try {
				ie.sendKeys(key, true);
				System.out.println("[" + getNow() + "]Key sended");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static String getNow() {
		SimpleDateFormat sdf = new SimpleDateFormat("hh:MM:ss:SSSS");
		return sdf.format(Calendar.getInstance().getTime());
	}

}
