<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="setValue" access="public" output="false" returntype="void">
		<cfargument name="SessionScope" type="any" required="true" />
		<cfargument name="name" type="string" required="true" />
		<cfargument name="value" type="any" required="false" />
		<cfif Len(ARGUMENTS.name) is 0>
			<cfthrow type="ILLEGAL_PARAMETER" errorcode="SESSIONMANAGER-ERROR-1" message="ARGUMENTS.name length is 0." />
		</cfif>
		<cfset ARGUMENTS.SessionScope[ARGUMENTS.name]=ARGUMENTS.value />
	</cffunction>

	<cffunction name="getValue" access="public" output="false" returntype="any">
		<cfargument name="SessionScope" type="any" required="true" />
		<cfargument name="name" type="string" required="true" />
		<cfargument name="defaultvalue" type="any" required="true" />
		<cfset var val=ARGUMENTS.defaultvalue />
		<cfif isExistValue(ARGUMENTS.SessionScope, ARGUMENTS.name)>
			<cfset val=ARGUMENTS.SessionScope[ARGUMENTS.name] />
			<cfset StructDelete(ARGUMENTS.SessionScope, ARGUMENTS.name) />
		</cfif>
		<cfreturn val />
	</cffunction>

	<cffunction name="isExistValue" access="public" output="false" returntype="boolean">
		<cfargument name="SessionScope" type="any" required="true" />
		<cfargument name="name" type="string" required="true" />
		<cfif StructKeyExists(ARGUMENTS.SessionScope, ARGUMENTS.name)>
			<cfreturn true />
		</cfif>
		<cfreturn false />
	</cffunction>

</cfcomponent>

