<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="doProcess" access="public" output="false" returntype="void">
		<cfargument name="componentName" type="string" required="true" />
		<cfset var pathutil=THIS.comMgr.getComponent("appcore.utils.PathUtil") />
		<cfset var fileutil=THIS.comMgr.getComponent("appcore.utils.FileUtil") />
		<cfset var driverPath=pathutil.convertPathImpl2Test(ARGUMENTS.componentName) />
		<cfset var driverAbsPath=ExpandPath(driverPath) />
		<cfset APPLICATION.logger.debuglog("CreateTestDriverProcess.cfc##doProcess componentName:#ARGUMENTS.componentName#") />
		<cfset APPLICATION.logger.debuglog("CreateTestDriverProcess.cfc##doProcess driverPath:#driverPath#") />
		<cfif FileExists(driverAbsPath)>
			<cfthrow type="Application" errorcode="1" message="wTestDriver͂łɑ݂ĂB">
		<cfelse>
			<cfset fileutil.createNewFile(driverAbsPath) />
		</cfif>
		<cfset APPLICATION.logger.debuglog("CreateTestDriverProcess.cfc##doProcess driverAbsPath:#driverAbsPath#") />
		<cflock scope="application" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="copy" destination="#driverAbsPath#"
					source="#ExpandPath(APPLICATION.ContentsRoot & '/appcore/lib/TestDriverTemplate.cfm')#" />
		</cflock>
	</cffunction>

</cfcomponent>
