<cfcomponent output="false">

	<cffunction name="selectByEventTypeId" access="public" output="false" returntype="query">
		<cfargument name="event_type_id" type="numeric" required="true" />
		<cfset var q="" />
		<cfquery datasource="#APPLICATION.DataSource#" name="q">
			SELECT * FROM EVENT_TYPE_MASTER
			WHERE EVENT_TYPE_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#ARGUMENTS.event_type_id#" />
		</cfquery>
		<cfreturn q />
	</cffunction>

	<cffunction name="create" access="public" output="false" returntype="void">
		<cfargument name="event_type_id" type="numeric" required="true" />
		<cfargument name="event_type_name" type="string" required="true" />
		<cfquery datasource="#APPLICATION.DataSource#">
			INSERT INTO EVENT_TYPE_MASTER
			(	EVENT_TYPE_ID
			,	EVENT_TYPE_NAME
			) VALUES (
				<cfqueryparam cfsqltype="cf_sql_integer" value="#ARGUMENTS.event_type_id#" />
			,	<cfqueryparam cfsqltype="cf_sql_varchar" value="#ARGUMENTS.event_type_name#" />
			)
		</cfquery>
	</cffunction>

	<cffunction name="update" access="public" output="false" returntype="void">
		<cfargument name="event_type_id" type="numeric" required="true" />
		<cfargument name="event_type_name" type="string" required="true" />
		<cfquery datasource="#APPLICATION.DataSource#">
			UPDATE EVENT_TYPE_MASTER
			SET	EVENT_TYPE_NAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#ARGUMENTS.event_type_name#" />
			WHERE EVENT_TYPE_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#ARGUMENTS.event_type_id#" />
		</cfquery>
	</cffunction>

	<cffunction name="deleteByEventTypeId" access="public" output="false" returntype="void">
		<cfargument name="event_type_id" type="numeric" required="true" />
		<cfquery datasource="#APPLICATION.DataSource#">
			DELETE FROM EVENT_TYPE_MASTER
			WHERE EVENT_TYPE_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#ARGUMENTS.event_type_id#" />
		</cfquery>
	</cffunction>

</cfcomponent>