<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [appcore/facade/flow/process/AppFileCopyProcess.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset com0=getComponentManager().getComponent("appcore.facade.flow.process.CreateAppRootProcess") />
			<cfset com=getComponentManager().getComponent("appcore.facade.flow.process.AppFileCopyProcess") />
			<cfset fileutil=getComponentManager().getComponent("appcore.utils.FileUtil") />
			<fieldset>
				<legend>doProcess</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="test_#DateFormat(Now(), 'YYYYMMDD')##TimeFormat(Now(), 'HHMMSS')#" />
					<cfset com0.doProcess(in) />
					<cfset exp=createFileList(in) />
					<cfset com.doProcess(in) />
					<cfset act=fileutil.createFileArray(ExpandPath("/#in#")) />
					<cfset assert(caseNo, "AvP[Vt@C#in#ɃRs[", in, exp, act) />

					<cftry>
						<cfset caseNo=IncrementValue(caseNo) />
						<cfset in="" />
						<cfset exp="1" />
						<cfset com0.doProcess(in) />
						<cfset com.doProcess(in) />
						<cfcatch>
							<cfset assert(caseNo, "󕶎w肵Ďs<br>G[R[h1̗Othrow",
							 in, exp, cfcatch.ErrorCode) />
						</cfcatch>
					</cftry>

					<cftry>
						<cfset caseNo=IncrementValue(caseNo) />
						<cfset in="/*?<>|" />
						<cfset exp="create" />
						<cfset com0.doProcess(in) />
						<cfset com.doProcess(in) />
						<cfcatch>
							<cfset assert(caseNo, "AvP[VƂĕsK؂ȖOw<br>Actoin=create̗Othrow",
							 in, exp, cfcatch.Action) />
						</cfcatch>
					</cftry>
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="createFileList" access="private" output="false" returntype="array">
	<cfargument name="appName" type="string" required="true" />
	<cfset var ret=ArrayNew(1) />
	<cfset var ret2=ArrayNew(1) />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/LICENSE.txt") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/Application.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/ApplicationProxy.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/Application.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/ApplicationProxy.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/cfneounit/Application.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/cfneounit/ApplicationProxy.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/cfneounit/CfneoTestRunner.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/cfneounit/CfneoTestSupporter.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/cfneounit/td_header.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/common/Application.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/common/appcontext.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/common/cfneo_logo.jpg") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/common/doContextReload.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/common/CfneoUnitErrorCodeList.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/ComponentManager.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/AppCoreFacade.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/AppContextInitializeFlow.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/CreateAppFlow.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/CreateTestDriverFlow.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/process/AppFileCopyProcess.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/process/CreateAppRootProcess.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/process/CreateTestDriverProcess.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/process/ModifyNewAppProcess.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/process/SetupAppContextProcess.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/flow/process/SetupAppLoggerProcess.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/facade/TestDriverFacade.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/lib/jquery-1.2.6.js") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/lib/style.css") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/lib/TestDriverTemplate.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/SessionManager.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/utils/ComponentUtil.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/utils/FileUtil.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/utils/Logger.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/appcore/utils/PathUtil.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/dev/test/Application.cfc") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/dev/test/doCreateTestDriver.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/dev/test/index.cfm") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/dev/test/style.css") />
	<cfset ArrayAppend(ret, "/#ARGUMENTS.appName#/dev/test/validator/CreateTestDriverValidator.cfc") />
	<cfloop index="idx" list="#ArrayToList(ret)#">
		<cfset ArrayAppend(ret2, LCase(idx)) />
	</cfloop>
	<cfreturn ret2 />
</cffunction>
