<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [appcore/facade/flow/process/ModifyNewAppProcess.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset com1=getComponentManager().getComponent("appcore.facade.flow.process.CreateAppRootProcess") />
			<cfset com2=getComponentManager().getComponent("appcore.facade.flow.process.AppFileCopyProcess") />
			<cfset com3=getComponentManager().getComponent("appcore.facade.flow.process.ModifyNewAppProcess") />
			<fieldset>
				<legend>doProcess</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset newAppName="ModifyTestApp">
					<cfset com1.doProcess(newAppName) />
					<cfset com2.doProcess(newAppName) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset newAppRoot=ExpandPath("/#newAppName#") />
					<cfset oldRegexKey1="extends=#Chr(34)##APPLICATION.ApplicationName#" />
					<cfset oldRegexKey2="=#Chr(34)##APPLICATION.ApplicationName##Chr(34)#" />
					<cfset oldSearchResult1=searchRegexLoop(newAppRoot, oldRegexKey1 ) />
					<cfset oldSearchResult2=searchRegexLoop(newAppRoot, oldRegexKey2 ) />
					
					<cfset com3.doProcess(newAppName) />
					
					<cfset newRegexKey1="extends=#Chr(34)##newAppName#" />
					<cfset newRegexKey2="=#Chr(34)##newAppName##Chr(34)#" />
					<cfset newSearchResult1=searchRegexLoop(newAppRoot, newRegexKey1 ) />
					<cfset newSearchResult2=searchRegexLoop(newAppRoot, newRegexKey2 ) />
					<cfset in="">
					<cfset exp=StructNew() />
					<cfset exp.searchResult1=oldSearchResult1 />
					<cfset exp.searchResult2=oldSearchResult2 />					
					<cfset act=StructNew() />
					<cfset act.searchResult1=newSearchResult1 />
					<cfset act.searchResult2=newSearchResult2 />
					<cfset assert(caseNo, "ׂẴt@C̕ϊΏە񂪕ϊĂ邩", in, exp, act) />
					
					<!--- | --->
					<cfdirectory action="delete" directory="#newAppRoot#" recurse="true" />
				</table>
			</fieldset>
			<cfset com=getComponentManager().getComponent("dev.test.appcore.facade.flow.process.ModifyNewAppProcess4Test") />
			<cfset futil=getComponentManager().getComponent("appcore.utils.FileUtil") />
			<fieldset>
				<legend>doModifyFile</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./ModifyNewAppProcessTest/tempa.txt") />
					<cfset com.appName="testapp" />
					<cfset exp="" />
					<cffile action="read" file="#ExpandPath('./ModifyNewAppProcessTest/tempb.txt')#" variable="exp" />
					<cfset com.doModifyFile(in) />
					<cfset act="" />
					<cffile action="read" file="#in#" variable="act" />
					<cfset assert(caseNo, "wt@CɑΏە݂", in, exp, act) />

					<cffile action="write" file="#in#" output="THIS.name=#Chr(34)#cfneo#Chr(34)##Chr(10)#<cfcomponent extends=#Chr(34)#cfneo.test.cfneounit.xxx#Chr(34)#>" />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./ModifyNewAppProcessTest/tempc.txt") />
					<cfset com.appName="testapp" />
					<cfset exp="" />
					<cffile action="read" file="#in#" variable="exp" />
					<cfset com.doModifyFile(in) />
					<cfset act="" />
					<cffile action="read" file="#in#" variable="act" />
					<cfset assert(caseNo, "wt@CɑΏە݂Ȃ", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset befAPath="#ExpandPath('./ModifyNewAppProcessTest/ApplicationA_before.cfc')#" />
					<cfset befAtxt="" />
					<cffile action="read" file="#befAPath#" variable="befAtxt" />
					<cfset in=ExpandPath('./ModifyNewAppProcessTest/ApplicationA.cfc') />
					<cfset futil.updateFile(in, befAtxt) />
					<cfset com.appName="testapp" />
					<cfset exp="" />
					<cffile action="read" file="#ExpandPath('./ModifyNewAppProcessTest/actual-ApplicationA.cfc')#" variable="exp" />
					<cfset com.doModifyFile(in) />
					<cfset act="" />
					<cffile action="read" file="#in#" variable="act" />
					<cfset assert(caseNo, "uextends=xxxvu", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset befBPath="#ExpandPath('./ModifyNewAppProcessTest/ApplicationB_before.cfc')#" />
					<cfset befBtxt="" />
					<cffile action="read" file="#befBPath#" variable="befBtxt" />
					<cfset in=ExpandPath("./ModifyNewAppProcessTest/ApplicationB.cfc") />
					<cfset com.appName="testapp" />
					<cfset exp="" />
					<cfset futil.updateFile(in, befBtxt) />
					<cffile action="read" file="#ExpandPath('./ModifyNewAppProcessTest/actual-ApplicationB.cfc')#" variable="exp" />
					<cfset com.doModifyFile(in) />
					<cfset act="" />
					<cffile action="read" file="#in#" variable="act" />
					<cfset assert(caseNo, "uTHIS.name=xxxvu", in, exp, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="searchRegexLoop" access="private" output="false" returntype="Struct">
	<cfargument name="root" type="string" required="true" />
	<cfargument name="target" type="string" required="true" />
	<cfargument name="resultStruct" type="Struct" default="#StructNew()#"required="false" />
	<cfset var dir="" />
	<cfset var path="" />
	<cfif Not StructKeyExists(resultStruct, "FindArr") >
		<cfset resultStruct.FindArr=ArrayNew(1) />
	</cfif>
	<cfdirectory action="list" directory="#ARGUMENTS.root#" name="dir" />
	<cfloop query="dir">
		<cfset path="#dir.DIRECTORY#\#dir.NAME#" />
		<cfif dir.TYPE is "Dir">
			<cfset resultArr=searchRegexLoop(path, target, resultStruct) />
		<cfelseif dir.TYPE is "File">
			<cffile action="read" file="#path#" variable="f" />
			<!--- t@C̒Aw肳ꂽp^[āǍʂzɃZbgĂ --->
			<cfset searchResult=StructNew() />
			<cfset searchResult.filename=dir.NAME />
			<cfset findSet=REFind(target, f, 1, true) />
			<cfset searchResult.findPos=findSet.POS />
			<cfset ArrayAppend(resultStruct.FindArr, searchResult) />
		</cfif>
	</cfloop>
	<cfreturn resultStruct />
</cffunction>

