<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [/examples/fizzbuzz/validator/FizzBuzzValidator.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset validator=getComponentManager().getComponent("examples.fizzbuzz.validator.FizzBuzzValidator") />
			<fieldset>
				<legend>validate</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset errCode="" />
					<cfset caseNo=0 />
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Normal",
							3, 5, "") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in["buzz"]=5 />
					<cftry>
						<cfinvoke component="#validator#" method="validate">
<!---
							<cfinvokeargument name="fizz" value='#in["fizz"]#' />
--->
							<cfinvokeargument name="buzz" value='#in["buzz"]#' />
						</cfinvoke>
						<cfcatch>
							<cfset errCode=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "Error(Fizzp[^Ɋ܂߂Ȃ)", in,
							"FIZZ_NOT_FOUND_1", errCode, "", false) />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Fizzɋ󕶎w)",
							"", 5, "FIZZ_NOT_FOUND_2") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Fizzɕ[aaa]w)",
							"aaa", 5, "FIZZ_NOT_NUMERIC") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Fizz0w)",
							0, 5, "FIZZ_IS_RANGE_OVER") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Fizz1w)",
							1, 5, "FIZZ_IS_RANGE_OVER") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Fizz11w)",
							11, 5, "FIZZ_IS_RANGE_OVER") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in["fizz"]=3 />
					<cftry>
						<cfinvoke component="#validator#" method="validate">
							<cfinvokeargument name="fizz" value='#in["fizz"]#' />
<!---
							<cfinvokeargument name="buzz" value='#in["buzz"]#' />
--->
						</cfinvoke>
						<cfcatch>
							<cfset errCode=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "Error(Buzzw肵Ȃ)", in,
							"BUZZ_NOT_FOUND_1", errCode, "", false) />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Buzzɋ󕶎w)",
							3, "", "BUZZ_NOT_FOUND_2") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Buzzɕ[aaa]w)",
							3, "aaa", "BUZZ_NOT_NUMERIC") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Buzz[0]w)",
							3, 0, "BUZZ_IS_RANGE_OVER") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Buzz[1]w)",
							3, 1, "BUZZ_IS_RANGE_OVER") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(Buzz[11]w)",
							3, 11, "BUZZ_IS_RANGE_OVER") />
	
					<!---///////////////////////////////////////////////////////--->
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset doTest(caseNo, "Error(FizzBuzzɓl)",
							3, 3, "FIZZ_IS_BUZZ") />
	
					<!---///////////////////////////////////////////////////////--->
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="doTest" access="private" returntype="void">
	<cfargument name="caseNo" type="string" required="true" />
	<cfargument name="note" type="string" required="true" />
	<cfargument name="fizz" type="any" required="true" />
	<cfargument name="buzz" type="any" required="true" />
	<cfargument name="expected" type="string" required="true" />
	<cfset var errcode="" />
	<cfset var validator=getComponentManager().getComponent("examples.fizzbuzz.validator.FizzBuzzValidator") />
	<cfset in=StructNew() />
	<cfset in["fizz"]=ARGUMENTS.fizz />
	<cfset in["buzz"]=ARGUMENTS.buzz />
	<cftry>
		<cfinvoke component="#validator#" method="validate">
			<cfinvokeargument name="fizz" value='#in["fizz"]#' />
			<cfinvokeargument name="buzz" value='#in["buzz"]#' />
		</cfinvoke>
		<cfcatch>
			<cfset errcode=cfcatch.ErrorCode />
		</cfcatch>
	</cftry>
	<cfset assert(ARGUMENTS.caseNo, ARGUMENTS.note, in,
			ARGUMENTS.expected, errCode, "", false) />
</cffunction>
