<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver []" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset com=getComponentManager().getComponent("examples.tw.dao.UserDao") />
			<fieldset>
				<legend>selectAll</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset exp=createUserArray() />
					<cfset act=com.selectAll() />
					<cfset assert("1", "invoke", "", exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>isExistsUser</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in="anonymous" />
					<cfset assert("1", "݂", in,
							true, com.isExistsUser(in)) />

					<cfset in="" />
					<cfset assert("2", "݂Ȃ", in,
							false, com.isExistsUser(in)) />
				</table>
			</fieldset>
			<fieldset>
				<legend>addUser</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in="newuser-#DateFormat(Now(), 'YYYYMMDD')##TimeFormat(Now(), 'hhmmss')#" />
					<cfset exp=createUserArray() />
					<cfset ArrayAppend(exp, in) />
					<cfset com.addUser(in) />
					<cfset act=createUserArray() />
					<cfset assert("1", "invoke", in, exp, act) />

					<cfset in="" />
					<cfset exp=createUserArray() />
					<cfset com.addUser(in) />
					<cfset act=createUserArray() />
					<cfset assert("2", "invoke", in, exp, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="createUserArray" access="private" returntype="array">
	<cfset var f="" />
	<cfset var idx="" />
	<cfset var arr=ArrayNew(1) />
	<cffile action="read" file="#ExpandPath('/cfneo/examples/tw/dao/files/user.txt')#" variable="f" />
	<cfloop index="idx" list="#f#" delimiters="#Chr(10)##Chr(13)#">
		<cfset ArrayAppend(arr, idx) />
	</cfloop>
	<cfreturn arr />
</cffunction>
