<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="doProcess" access="public" output="false" returntype="void">
		<cfargument name="appName" type="string" required="true" />
		<cfif Trim(ARGUMENTS.appName) is "">
			<cfthrow type="application" errorcode="1" message="Application namewB" />
		</cfif>
		<cfset THIS.appName=ARGUMENTS.appName />
		<cfset copyDirectories(ExpandPath("#APPLICATION.ContentsRoot#/appcore")) />
		<cfset copyDirectories(ExpandPath("#APPLICATION.ContentsRoot#/dev/test/validator")) />
		<cfset copyFiles() />
	</cffunction>

	<cffunction name="copyDirectories" access="private" output="false" returntype="void">
		<cfargument name="root" type="string" required="true" />
		<cfset var dir="" />
		<cfset var basePath="" />
		<cfset var newPath="" />
		<cfset var newRoot=convertRootPackageName(ARGUMENTS.root) />
		<cfif not DirectoryExists(newRoot)>
			<cfdirectory action="create" directory="#newRoot#" />
		</cfif>
		<cfdirectory action="list" directory="#ARGUMENTS.root#" name="dir" />
		<cfloop query="dir">
			<cfif ListFind(".svn,app.log,.project", dir.NAME) is 0>
				<cfset basePath="#dir.DIRECTORY#\#dir.NAME#" />
				<cfset newPath=convertRootPackageName(basePath) />
				<cfif dir.TYPE is "Dir">
					<cfif not DirectoryExists(newPath)>
						<cfdirectory action="create" directory="#newPath#" />
					</cfif>
					<cfset copyDirectories(basePath) />
				<cfelseif dir.TYPE is "File">
					<cfset APPLICATION.logger.debuglog("##copyDirectories THIS.appName:[#THIS.appName#]...basePath:[#basePath#]/newPath:[#newPath#]") />
					<cffile action="copy" source="#basePath#" destination="#newPath#" />
				</cfif>
			</cfif>
		</cfloop>
	</cffunction>

	<cffunction name="copyFiles" access="private" output="false" returntype="void">
		<cfset var filelist=ArrayNew(1) />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/Application.cfc") />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/ApplicationProxy.cfc") />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/LICENSE.txt") />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/dev/test/Application.cfc") />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/dev/test/doCreateTestDriver.cfm") />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/dev/test/index.cfm") />
		<cfset ArrayAppend(filelist, "#APPLICATION.ContentsRoot#/dev/test/style.css") />
		<cfset doCopy(filelist) />
	</cffunction>

	<cffunction name="doCopy" access="private" output="false" returntype="void">
		<cfargument name="filelist" type="array" required="true" />
		<cfset var idx="" />
		<cfset var basePath="" />
		<cfset var newPath="" />
		<cfloop index="idx" list="#ArrayToList(ARGUMENTS.filelist)#">
			<cfset basePath=ExpandPath(idx) />
			<cfset newPath=convertRootPackageName(basePath) />
			<cfset APPLICATION.logger.debuglog("##doCopy basePath:[#basePath#]/newPath:[#newPath#]") />
			<cffile action="copy" source="#basePath#" destination="#newPath#" />
		</cfloop>
	</cffunction>

	<cffunction name="convertRootPackageName" access="private" output="false" returntype="string">
		<cfargument name="path" type="string" required="true" />
		<cfreturn REReplace(ARGUMENTS.path, "\\#APPLICATION.ApplicationName#\\", "\#THIS.appName#\") />
	</cffunction>

</cfcomponent>
