<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="doProcess" access="public" output="false" returntype="void">
		<cfargument name="appName" type="string" required="true" />
		<cfset var newRoot=ExpandPath("/#ARGUMENTS.appName#") />
		<cfset THIS.appName=ARGUMENTS.appName />
		<cfset doModifyLoop(newRoot) />
	</cffunction>

	<cffunction name="doModifyLoop" access="private" output="false" returntype="void">
		<cfargument name="root" type="string" required="true" />
		<cfset var dir="" />
		<cfset var path="" />
		<cfdirectory action="list" directory="#ARGUMENTS.root#" name="dir" />
		<cfloop query="dir">
			<cfset path="#dir.DIRECTORY#\#dir.NAME#" />
			<cfif dir.TYPE is "Dir">
				<cfset doModifyLoop(path) />
			<cfelseif dir.TYPE is "File">
				<cfset doModifyFile(path) />
			</cfif>
		</cfloop>
	</cffunction>

	<cffunction name="doModifyFile" access="private" output="false" returntype="void">
		<cfargument name="path" type="string" required="true" />
		<cfset var fileutil=THIS.comMgr.getComponent("appcore.utils.FileUtil") />
		<cfset var f="" />
		<cfset var nf="" />
		<cfset var findset="" />
		<cfset var regexKey1="extends=#Chr(34)##APPLICATION.ApplicationName#" />
		<cfset var regexKey2="=#Chr(34)##APPLICATION.ApplicationName##Chr(34)#" />
		<cfset APPLICATION.logger.debuglog("##doModifyFile file=[#ARGUMENTS.path#]") />
		<cffile action="read" file="#ARGUMENTS.path#" variable="f" />
		<cfset nf=f />
		<cfset findset=REFind(regexKey1, nf, 0, true) />
		<cfif findset.POS[1] gt 0 and findset.LEN[1] gt 0>
			<!---// extends="xxx.~"ւ̍XV //--->
			<cfset nf=REReplace(nf, regexKey1,
					"extends=#Chr(34)##THIS.appName#") />
		</cfif>
		<cfset findset=REFind(regexKey2, nf, 0, true) />
		<cfif findset.POS[1] gt 0 and findset.LEN[1] gt 0>
			<!---// ̑̃e̍XV //--->
			<cfset nf=REReplace(nf,
					regexKey2,
					"=#Chr(34)##THIS.appName##Chr(34)#") />
		</cfif>
		<cfset APPLICATION.logger.debuglog("##doModifyFile contents=[#nf#]") />
		<cfset fileutil.updateFile(ARGUMENTS.path, nf) />
	</cffunction>

</cfcomponent>
