/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Button;
import watij.finders.FinderFactory;
import watij.finders.SymbolFactory;
import watij.runtime.ObjectDisabledException;
import watij.runtime.UnknownObjectException;
import watij.runtime.ie.IE;

public class ButtonsTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "buttons1.html");
    }

    public void goToFramesPage() throws Exception {
        ie.goTo(HTML_ROOT + "frame_buttons.html");
    }

    public void testButtonElementDoesntExistAfterClosingBrowser() throws Exception {
        IE ie = new IE();
        ie.start(HTML_ROOT + "buttons1.html");
        Button button = ie.button(SymbolFactory.name, "buttonTag");
        ButtonsTest.assertTrue((boolean)button.exists());
        ie.close();
        ButtonsTest.assertFalse((boolean)button.exists());
    }

    public void testButtonTag() throws Exception {
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.name, "buttonTag").exists());
        ButtonsTest.assertEquals((String)"I am a tag called button", (String)ie.button(SymbolFactory.name, "buttonTag").text());
    }

    public void testButtonMultipleFinders() throws Exception {
        ie.button(FinderFactory.name("samename"), FinderFactory.value("samevalue"), FinderFactory.id("sameid")).click();
        ButtonsTest.assertEquals((String)"samevalue4", (String)ie.textField(SymbolFactory.id, "samevaluetest").value());
        ie.button(FinderFactory.name("samename"), FinderFactory.value("samevalue"), FinderFactory.id("sameid"), FinderFactory.index(1)).click();
        ButtonsTest.assertEquals((String)"samevalue5", (String)ie.textField(SymbolFactory.id, "samevaluetest").value());
    }

    public void testButtonMultipleFindersBadOrder() throws Exception {
        Button button = ie.button(FinderFactory.index(0), FinderFactory.name("samename"), FinderFactory.value("samevalue"), FinderFactory.id("sameid"));
        ButtonsTest.assertFalse((boolean)button.exists());
    }

    public void testButtonProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.button(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.button(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodDisabled(ie.button(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.button(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.button(SymbolFactory.name, "noName"));
        ButtonsTest.assertEquals((String)"b1", (String)ie.button(0).name());
        ButtonsTest.assertEquals((String)"b2", (String)ie.button(0).id());
        ButtonsTest.assertEquals((String)"button", (String)ie.button(0).type());
        ButtonsTest.assertEquals((String)"Click Me", (String)ie.button(0).value());
        ButtonsTest.assertEquals((boolean)false, (boolean)ie.button(0).disabled());
        ButtonsTest.assertEquals((String)"italic_button", (String)ie.button(SymbolFactory.name, "b1").className());
        ButtonsTest.assertEquals((String)"", (String)ie.button(SymbolFactory.name, "b4").className());
        ButtonsTest.assertEquals((String)"b1", (String)ie.button(SymbolFactory.id, "b2").name());
        ButtonsTest.assertEquals((String)"b2", (String)ie.button(SymbolFactory.id, "b2").id());
        ButtonsTest.assertEquals((String)"button", (String)ie.button(SymbolFactory.id, "b2").type());
        ButtonsTest.assertEquals((String)"b4", (String)ie.button(1).name());
        ButtonsTest.assertEquals((String)"b5", (String)ie.button(1).id());
        ButtonsTest.assertEquals((String)"button", (String)ie.button(1).type());
        ButtonsTest.assertEquals((String)"Disabled Button", (String)ie.button(1).value());
        ButtonsTest.assertEquals((boolean)true, (boolean)ie.button(1).disabled());
        ButtonsTest.assertEquals((String)"", (String)ie.button(1).title());
        ButtonsTest.assertEquals((String)"this is button1", (String)ie.button(0).title());
    }

    public void testButtonUsingDefault() throws Exception {
        try {
            ie.button("Missing Caption").click();
            ButtonsTest.fail((String)"Did not throw UnknownObjectException");
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        ie.button("Click Me").click();
        ButtonsTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testButtonClickOnly() throws Exception {
        ie.button(SymbolFactory.caption, "Click Me").click();
        ButtonsTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testButtonClick() throws Exception {
        try {
            ie.button(SymbolFactory.caption, "Missing Caption").click();
            ButtonsTest.fail((String)"Did not throw UnknownObjectException");
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.button(SymbolFactory.id, "missingID").click();
            ButtonsTest.fail((String)"Did not throw UnknownObjectException");
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.button(SymbolFactory.caption, "Disabled Button").click();
            ButtonsTest.fail((String)"Did not throw ObjectDisabledException");
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
        ie.button(SymbolFactory.caption, "Click Me").click();
        ButtonsTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testButtonExists() throws Exception {
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.caption, "Click Me").exists());
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.caption, "Submit").exists());
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.name, "b1").exists());
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.id, "b2").exists());
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.caption, "/(?i:sub)/").exists());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.caption, "missingcaption").exists());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.name, "missingname").exists());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.id, "missingid").exists());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.caption, "/(?i:missing)/").exists());
    }

    public void testButtonEnabled() throws Exception {
        ButtonsTest.assertTrue((boolean)ie.button(SymbolFactory.caption, "Click Me").enabled());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.caption, "Disabled Button").enabled());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.name, "b4").enabled());
        ButtonsTest.assertFalse((boolean)ie.button(SymbolFactory.id, "b5").enabled());
    }

    public void testFrame() throws Exception {
        this.goToFramesPage();
        ButtonsTest.assertTrue((boolean)ie.frame("buttonFrame").button(SymbolFactory.caption, "Click Me").enabled());
        try {
            ie.button(SymbolFactory.caption, "Disabled Button").enabled();
            ButtonsTest.fail((String)"Did not throw UnknownObjectException");
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }
}

