/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Div;
import watij.elements.Divs;
import watij.elements.Span;
import watij.elements.Spans;
import watij.finders.SymbolFactory;

public class DivTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "div.html");
    }

    public void testDivs() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.div(SymbolFactory.id, "div77"));
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.div(SymbolFactory.title, "div77"));
        DivTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains("0"));
        ie.div(SymbolFactory.id, "div3").click();
        DivTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains("1"));
        ie.div(SymbolFactory.id, "div4").click();
        DivTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains("0"));
    }

    public void testDivProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodText(ie.div(SymbolFactory.id, "div77"));
        this.assertRaisesUnknownObjectExceptionForMethodText(ie.div(SymbolFactory.title, "div77"));
        DivTest.assertEquals((String)"This div has an onClick that increments text1", (String)ie.div(SymbolFactory.id, "div3").text().trim());
        DivTest.assertEquals((String)"This text is in a div with an id of div1 and title of test1", (String)ie.div(SymbolFactory.title, "Test1").text().trim());
        this.assertRaisesUnknownObjectExceptionForMethodClassName(ie.div(SymbolFactory.id, "div77"));
        DivTest.assertEquals((String)"blueText", (String)ie.div(SymbolFactory.id, "div2").className());
        DivTest.assertEquals((String)"", (String)ie.div(SymbolFactory.id, "div1").className());
        this.assertRaisesUnknownObjectExceptionForMethodClassName(ie.div(44));
        DivTest.assertEquals((String)"div1", (String)ie.div(0).id());
        DivTest.assertEquals((String)"", (String)ie.div(0).className());
        DivTest.assertEquals((String)"blueText", (String)ie.div(1).className());
        DivTest.assertEquals((String)"", (String)ie.div(1).value());
        DivTest.assertEquals((boolean)false, (boolean)ie.div(1).disabled());
        DivTest.assertEquals((String)"div2", (String)ie.div(1).id());
    }

    public void testDivIterator() throws Exception {
        DivTest.assertEquals((int)7, (int)ie.divs().length());
        DivTest.assertEquals((String)"div1", (String)((Div)ie.divs().get(0)).id());
        int j = 0;
        Divs divs = ie.divs();
        for (Div div : divs) {
            DivTest.assertEquals((String)ie.div(j).id(), (String)div.id());
            DivTest.assertEquals((String)ie.div(j).className(), (String)div.className());
            ++j;
        }
        DivTest.assertEquals((int)j, (int)ie.divs().length());
    }

    public void test_objects_in_div() throws Exception {
        DivTest.assertTrue((boolean)ie.div(SymbolFactory.id, "buttons1").button(0).exists());
        DivTest.assertFalse((boolean)ie.div(SymbolFactory.id, "buttons1").button(2).exists());
        DivTest.assertTrue((boolean)ie.div(SymbolFactory.id, "buttons1").button(SymbolFactory.name, "b1").exists());
        DivTest.assertTrue((boolean)ie.div(SymbolFactory.id, "buttons2").button(0).exists());
        DivTest.assertTrue((boolean)ie.div(SymbolFactory.id, "buttons2").button(1).exists());
        DivTest.assertFalse((boolean)ie.div(SymbolFactory.id, "buttons1").button(2).exists());
        ie.div(SymbolFactory.id, "buttons1").button(0).click();
        DivTest.assertEquals((String)"button1", (String)ie.div(SymbolFactory.id, "text_fields1").textField(0).value());
        DivTest.assertEquals((int)3, (int)ie.div(SymbolFactory.id, "text_fields1").textFields().length());
    }

    public void testSpans() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.span(SymbolFactory.id, "span77"));
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.span(SymbolFactory.title, "span77"));
        DivTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text2").verifyContains("0"));
        ie.span(SymbolFactory.id, "span3").click();
        DivTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text2").verifyContains("1"));
        ie.span(SymbolFactory.id, "span4").click();
        DivTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text2").verifyContains("0"));
    }

    public void testSpanProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodText(ie.span(SymbolFactory.id, "span77"));
        this.assertRaisesUnknownObjectExceptionForMethodText(ie.span(SymbolFactory.title, "span77"));
        DivTest.assertEquals((String)"This span has an onClick that increments text2", (String)ie.span(SymbolFactory.id, "span3").text().trim());
        DivTest.assertEquals((String)"This text is in a span with an id of span1 and title of test2", (String)ie.span(SymbolFactory.title, "Test2").text().trim());
        this.assertRaisesUnknownObjectExceptionForMethodClassName(ie.span(SymbolFactory.id, "span77"));
        DivTest.assertEquals((String)"blueText", (String)ie.span(SymbolFactory.id, "span2").className());
        DivTest.assertEquals((String)"", (String)ie.span(SymbolFactory.id, "span1").className());
        this.assertRaisesUnknownObjectExceptionForMethodClassName(ie.span(44));
        DivTest.assertEquals((String)"span1", (String)ie.span(0).id());
        DivTest.assertEquals((String)"", (String)ie.span(0).className());
        DivTest.assertEquals((String)"blueText", (String)ie.span(1).className());
        DivTest.assertEquals((String)"", (String)ie.span(1).value());
        DivTest.assertEquals((boolean)false, (boolean)ie.span(1).disabled());
        DivTest.assertEquals((String)"span2", (String)ie.span(1).id());
    }

    public void testSpanIterator() throws Exception {
        DivTest.assertEquals((int)7, (int)ie.spans().length());
        DivTest.assertEquals((String)"span1", (String)((Span)ie.spans().get(0)).id());
        int j = 0;
        Spans spans = ie.spans();
        for (Span span : spans) {
            DivTest.assertEquals((String)ie.span(j).id(), (String)span.id());
            DivTest.assertEquals((String)ie.span(j).className(), (String)span.className());
            ++j;
        }
        DivTest.assertEquals((int)j, (int)ie.spans().length());
    }

    public void test_objects_in_span() throws Exception {
        DivTest.assertTrue((boolean)ie.span(SymbolFactory.id, "buttons1").button(0).exists());
        DivTest.assertFalse((boolean)ie.span(SymbolFactory.id, "buttons1").button(2).exists());
        DivTest.assertTrue((boolean)ie.span(SymbolFactory.id, "buttons1").button(SymbolFactory.name, "b1").exists());
        DivTest.assertTrue((boolean)ie.span(SymbolFactory.id, "buttons2").button(0).exists());
        DivTest.assertTrue((boolean)ie.span(SymbolFactory.id, "buttons2").button(1).exists());
        DivTest.assertFalse((boolean)ie.span(SymbolFactory.id, "buttons1").button(2).exists());
        ie.span(SymbolFactory.id, "buttons1").button(0).click();
        DivTest.assertEquals((String)"button1", (String)ie.span(SymbolFactory.id, "text_fields1").textField(0).value());
        DivTest.assertEquals((int)3, (int)ie.span(SymbolFactory.id, "text_fields1").textFields().length());
    }
}

