/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Hidden;
import watij.finders.SymbolFactory;
import watij.runtime.UnknownObjectException;

public class FormsTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "forms2.html");
    }

    public void testFormExists() throws Exception {
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.name, "test2").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.name, "missing").exists());
        FormsTest.assertTrue((boolean)ie.form("test2").exists());
        FormsTest.assertFalse((boolean)ie.form("missing").exists());
        FormsTest.assertTrue((boolean)ie.form(0).exists());
        FormsTest.assertFalse((boolean)ie.form(88).exists());
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.method, "get").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.method, "missing").exists());
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.action, "pass.html").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.action, "missing").exists());
    }

    public void testButtonInForm() throws Exception {
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.name, "test2").button(SymbolFactory.caption, "Submit").exists());
    }

    public void testFormHtml() throws Exception {
        FormsTest.assertEquals((String)"\r\n<FORM name=test2 action=pass2.html method=get><BR><INPUT type=submit value=Submit> </FORM>", (String)ie.form(SymbolFactory.name, "test2").html());
    }

    public void testFormFlash() throws Exception {
        try {
            ie.form(SymbolFactory.name, "test2").flash();
        }
        catch (Exception e) {
            FormsTest.fail((String)"Exception should not have been thrown");
        }
    }

    public void test_form_sub_element() throws Exception {
        FormsTest.assertEquals((String)"Click Me", (String)ie.form(0).button(SymbolFactory.name, "b1").value());
    }

    public void test_showforms() throws Exception {
        ie.forms().show();
    }

    public void test_Form_Exists() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.name, "test2").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.name, "missing").exists());
        FormsTest.assertTrue((boolean)ie.form("test2").exists());
        FormsTest.assertFalse((boolean)ie.form("missing").exists());
        FormsTest.assertTrue((boolean)ie.form(0).exists());
        FormsTest.assertFalse((boolean)ie.form(88).exists());
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.method, "get").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.method, "missing").exists());
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.action, "pass.html").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.action, "missing").exists());
    }

    public void test_index_other_element_before_it() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsTest.assertEquals((String)"check1", (String)ie.checkbox(0).name());
    }

    public void test_reset() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        ie.textField(SymbolFactory.id, "t1").set("Hello, reset test!");
        FormsTest.assertEquals((String)ie.textField(SymbolFactory.id, "t1").getContents(), (String)"Hello, reset test!");
        ie.button(SymbolFactory.caption, "Reset").click();
        FormsTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.id, "t1").getContents());
        ie.textField(SymbolFactory.id, "t1").set("reset test - using a form");
        FormsTest.assertEquals((String)ie.textField(SymbolFactory.id, "t1").getContents(), (String)"reset test - using a form");
        ie.form(1).button(1).click();
        FormsTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.id, "t1").getContents());
        ie.textField(SymbolFactory.id, "t1").set("reset test - using a form");
        FormsTest.assertEquals((String)ie.textField(SymbolFactory.id, "t1").getContents(), (String)"reset test - using a form");
        ie.form(1).button(SymbolFactory.id, "reset_button").click();
        FormsTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.id, "t1").getContents());
    }

    public void test_flash1() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        ie.form(SymbolFactory.name, "test2").button(SymbolFactory.caption, "Submit").flash();
    }

    public void test_objects_with_same_name() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsTest.assertEquals((String)"textfield", (String)ie.textField(SymbolFactory.name, "g1").value());
        FormsTest.assertEquals((String)"button", (String)ie.button(SymbolFactory.name, "g1").value());
        FormsTest.assertEquals((String)"1", (String)ie.checkbox(SymbolFactory.name, "g1").value());
        FormsTest.assertEquals((String)"2", (String)ie.radio(SymbolFactory.name, "g1").value());
        FormsTest.assertEquals((String)"textfield_id", (String)ie.textField(SymbolFactory.id, "g1").value());
        FormsTest.assertEquals((String)"button_id", (String)ie.button(SymbolFactory.id, "g1").value());
        FormsTest.assertEquals((String)"1_id", (String)ie.checkbox(SymbolFactory.id, "g1").value());
        FormsTest.assertEquals((String)"2_id", (String)ie.radio(SymbolFactory.id, "g1").value());
    }

    public void test_flash2() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        ie.button(SymbolFactory.value, "Click Me").flash();
        try {
            ie.textField(SymbolFactory.name, "g177").flash();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    public void test_submitWithImage() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsTest.assertTrue((boolean)ie.button(SymbolFactory.alt, "submit").exists());
        FormsTest.assertTrue((boolean)ie.button(SymbolFactory.alt, "/sub/").exists());
        FormsTest.assertFalse((boolean)ie.button(SymbolFactory.alt, "missing").exists());
        FormsTest.assertFalse((boolean)ie.button(SymbolFactory.alt, "/missing/").exists());
        FormsTest.assertTrue((boolean)ie.button(SymbolFactory.src, "/button/").exists());
        FormsTest.assertFalse((boolean)ie.button(SymbolFactory.src, "missing").exists());
        FormsTest.assertFalse((boolean)ie.button(SymbolFactory.src, "/missing/").exists());
        ie.button(SymbolFactory.src, "/button/").click();
        FormsTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void test_find_textField_ignoring_form() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        FormsTest.assertEquals((String)ie.textField(SymbolFactory.name, "name").getContents(), (String)"apple");
    }

    public void test_correct_form_field_is_found_using_form_name() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        FormsTest.assertEquals((String)ie.form(SymbolFactory.name, "apple_form").textField(SymbolFactory.name, "name").getContents(), (String)"apple");
        FormsTest.assertEquals((String)ie.form(SymbolFactory.name, "banana_form").textField(SymbolFactory.name, "name").getContents(), (String)"banana");
    }

    public void test_correct_form_field_is_found_using_form_index() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        FormsTest.assertEquals((String)ie.form(0).textField(SymbolFactory.name, "name").getContents(), (String)"apple");
        FormsTest.assertEquals((String)ie.form(1).textField(SymbolFactory.name, "name").getContents(), (String)"banana");
    }

    public void test_using_text_on_form() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        ie.form(SymbolFactory.name, "apple_form").textField(SymbolFactory.name, "name").set("strudel");
        FormsTest.assertEquals((String)ie.form(0).textField(SymbolFactory.name, "name").getContents(), (String)"strudel");
    }

    public void test_submit() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        ie.form(SymbolFactory.name, "apple_form").submit();
        FormsTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void test_hidden() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsTest.assertTrue((boolean)ie.hidden(0).exists());
        FormsTest.assertTrue((boolean)ie.hidden(1).exists());
        FormsTest.assertFalse((boolean)ie.hidden(2).exists());
        ie.hidden(0).set("44");
        ie.hidden(1).set("55");
        ie.button(SymbolFactory.value, "Show Hidden").click();
        FormsTest.assertEquals((String)"44", (String)ie.textField(SymbolFactory.name, "vis1").value());
        FormsTest.assertEquals((String)"55", (String)ie.textField(SymbolFactory.name, "vis2").value());
        FormsTest.assertTrue((boolean)ie.hidden(SymbolFactory.name, "hid1").exists());
        FormsTest.assertTrue((boolean)ie.hidden(SymbolFactory.id, "hidden_1").exists());
        FormsTest.assertFalse((boolean)ie.hidden(SymbolFactory.name, "hidden_44").exists());
        FormsTest.assertFalse((boolean)ie.hidden(SymbolFactory.id, "hidden_55").exists());
        ie.hidden(SymbolFactory.name, "hid1").set("444");
        ie.hidden(SymbolFactory.id, "hidden_1").set("555");
        ie.button(SymbolFactory.value, "Show Hidden").click();
        FormsTest.assertEquals((String)"444", (String)ie.textField(SymbolFactory.name, "vis1").value());
        FormsTest.assertEquals((String)"555", (String)ie.textField(SymbolFactory.name, "vis2").value());
        ie.hidden(SymbolFactory.name, "hid1").append("a");
        ie.button(SymbolFactory.value, "Show Hidden").click();
        FormsTest.assertEquals((String)"444a", (String)ie.textField(SymbolFactory.name, "vis1").value());
        FormsTest.assertEquals((String)"555", (String)ie.textField(SymbolFactory.name, "vis2").value());
        ie.hidden(SymbolFactory.name, "hid1").clear();
        ie.button(SymbolFactory.value, "Show Hidden").click();
        FormsTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.name, "vis1").value());
        FormsTest.assertEquals((String)"555", (String)ie.textField(SymbolFactory.name, "vis2").value());
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.name, "has_a_hidden").hidden(SymbolFactory.name, "hid1").exists());
        FormsTest.assertTrue((boolean)ie.form(SymbolFactory.name, "has_a_hidden").hidden(SymbolFactory.id, "hidden_1").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.name, "has_a_hidden").hidden(SymbolFactory.name, "hidden_44").exists());
        FormsTest.assertFalse((boolean)ie.form(SymbolFactory.name, "has_a_hidden").hidden(SymbolFactory.id, "hidden_55").exists());
        ie.form(SymbolFactory.name, "has_a_hidden").hidden(SymbolFactory.name, "hid1").set("222");
        ie.form(SymbolFactory.name, "has_a_hidden").hidden(SymbolFactory.id, "hidden_1").set("333");
        ie.button(SymbolFactory.value, "Show Hidden").click();
        FormsTest.assertEquals((String)"222", (String)ie.textField(SymbolFactory.name, "vis1").value());
        FormsTest.assertEquals((String)"333", (String)ie.textField(SymbolFactory.name, "vis2").value());
        FormsTest.assertEquals((int)2, (int)ie.hiddens().length());
        int count = 0;
        for (Hidden h : ie.hiddens()) {
            if (count == 0) {
                FormsTest.assertEquals((String)"", (String)h.id());
                FormsTest.assertEquals((String)"hid1", (String)h.name());
            }
            if (count == 1) {
                FormsTest.assertEquals((String)"", (String)h.name());
                FormsTest.assertEquals((String)"hidden_1", (String)h.id());
            }
            ++count;
        }
        FormsTest.assertEquals((String)"hid1", (String)((Hidden)ie.hiddens().get(0)).name());
        FormsTest.assertEquals((String)"hidden_1", (String)((Hidden)ie.hiddens().get(1)).id());
    }
}

