/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Radio;
import watij.elements.Radios;
import watij.finders.SymbolFactory;

public class RadiosTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "radioButtons1.html");
    }

    public void testRadioExists() throws Exception {
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box1").exists());
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.id, "box5").exists());
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "missingname").exists());
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.id, "missingid").exists());
    }

    public void testRadioClass() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClassName(ie.radio(SymbolFactory.name, "noName"));
        RadiosTest.assertEquals((String)"radio_style", (String)ie.radio(SymbolFactory.name, "box1").className());
        RadiosTest.assertEquals((String)"", (String)ie.radio(SymbolFactory.id, "box5").className());
    }

    public void testRadioEnabled() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.radio(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.radio(SymbolFactory.id, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.radio(SymbolFactory.name, "box4", 6));
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box2").enabled());
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.id, "box5").enabled());
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box1").enabled());
    }

    public void testLittle() throws Exception {
        RadiosTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
    }

    public void testOnClick() throws Exception {
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box5").isSet());
        RadiosTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.radio(SymbolFactory.name, "box5", 1).set();
        RadiosTest.assertTrue((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.radio(SymbolFactory.name, "box5", 1).set();
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box5", 1).isSet());
        RadiosTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.radio(SymbolFactory.name, "box5", 1).set();
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box5", 1).isSet());
        RadiosTest.assertTrue((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.radio(SymbolFactory.name, "box5", 2).set();
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box5", 1).isSet());
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box5", 2).isSet());
        RadiosTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
    }

    public void testRadioIsSet() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodIsSet(ie.radio(SymbolFactory.name, "noName"));
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box1").isSet());
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box3").isSet());
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box2").isSet());
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box4", 1).isSet());
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box4", 2).isSet());
    }

    public void testRadioClear() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClear(ie.radio(SymbolFactory.name, "noName"));
        ie.radio(SymbolFactory.name, "box1").clear();
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box1").isSet());
        this.assertRaisesDisabledObjectExceptionForMethodClear(ie.radio(SymbolFactory.name, "box2"));
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box2").isSet());
        ie.radio(SymbolFactory.name, "box3").clear();
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box2").isSet());
        ie.radio(SymbolFactory.name, "box4", 1).clear();
        RadiosTest.assertFalse((boolean)ie.radio(SymbolFactory.name, "box4", 1).isSet());
    }

    public void testRadioGetState() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodGetState(ie.radio(SymbolFactory.name, "noName"));
        RadiosTest.assertEquals((boolean)false, (boolean)ie.radio(SymbolFactory.name, "box1").getState());
        RadiosTest.assertEquals((boolean)true, (boolean)ie.radio(SymbolFactory.name, "box3").getState());
        RadiosTest.assertEquals((boolean)false, (boolean)ie.radio(SymbolFactory.name, "box4", 2).getState());
        RadiosTest.assertEquals((boolean)true, (boolean)ie.radio(SymbolFactory.name, "box4", 1).getState());
    }

    public void testRadioSet() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodSet(ie.radio(SymbolFactory.name, "noName"));
        ie.radio(SymbolFactory.name, "box1").set();
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box1").isSet());
        this.assertRaisesDisabledObjectExceptionForMethodSet(ie.radio(SymbolFactory.name, "box2"));
        ie.radio(SymbolFactory.name, "box3").set();
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box3").isSet());
        ie.radio(SymbolFactory.name, "box4", 3).set();
        RadiosTest.assertTrue((boolean)ie.radio(SymbolFactory.name, "box4", 3).isSet());
    }

    public void testRadioProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.radio(999));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.radio(999));
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.radio(999));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.radio(999));
        RadiosTest.assertEquals((String)"on", (String)ie.radio(0).value());
        RadiosTest.assertEquals((String)"box1", (String)ie.radio(0).name());
        RadiosTest.assertEquals((String)"", (String)ie.radio(0).id());
        RadiosTest.assertEquals((String)"radio", (String)ie.radio(0).type());
        RadiosTest.assertEquals((boolean)false, (boolean)ie.radio(0).disabled());
        RadiosTest.assertEquals((boolean)true, (boolean)ie.radio(2).disabled());
        RadiosTest.assertEquals((String)"box5", (String)ie.radio(1).id());
        RadiosTest.assertEquals((String)"", (String)ie.radio(1).name());
        RadiosTest.assertEquals((String)"box4-value5", (String)ie.radio(SymbolFactory.name, "box4", 5).title());
        RadiosTest.assertEquals((String)"", (String)ie.radio(SymbolFactory.name, "box4", 4).title());
    }

    public void testRadioIterators() throws Exception {
        Radios radios = ie.radios();
        RadiosTest.assertEquals((int)11, (int)radios.length());
        RadiosTest.assertEquals((String)"box5", (String)((Radio)radios.get(1)).id());
        RadiosTest.assertEquals((boolean)true, (boolean)((Radio)radios.get(2)).disabled());
        RadiosTest.assertEquals((boolean)false, (boolean)((Radio)radios.get(0)).disabled());
        int i = 0;
        for (Radio radio : radios) {
            RadiosTest.assertEquals((String)ie.radio(i).name(), (String)radio.name());
            RadiosTest.assertEquals((String)ie.radio(i).id(), (String)radio.id());
            RadiosTest.assertEquals((String)ie.radio(i).value(), (String)radio.value());
            RadiosTest.assertEquals((boolean)ie.radio(i).disabled(), (boolean)radio.disabled());
            ++i;
        }
        RadiosTest.assertEquals((int)i, (int)radios.length());
    }
}

