/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.SelectList;
import watij.elements.SelectLists;
import watij.finders.SymbolFactory;
import watij.runtime.NoValueFoundException;
import watij.runtime.UnknownObjectException;

public class SelectboxTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "selectBoxes1.html");
    }

    public void testSelectListExists() throws Exception {
        SelectboxTest.assertTrue((boolean)ie.selectList(SymbolFactory.name, "sel1").exists());
        SelectboxTest.assertFalse((boolean)ie.selectList(SymbolFactory.name, "missing").exists());
        SelectboxTest.assertFalse((boolean)ie.selectList(SymbolFactory.id, "missing").exists());
    }

    public void testSelectListEnabled() throws Exception {
        SelectboxTest.assertTrue((boolean)ie.selectList(SymbolFactory.name, "sel1").enabled());
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.selectList(SymbolFactory.name, "NoName"));
        SelectboxTest.assertFalse((boolean)ie.selectList(SymbolFactory.id, "selectbox_4").enabled());
    }

    public void testSelectListClassName() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClassName(ie.selectList(SymbolFactory.name, "missing"));
        SelectboxTest.assertEquals((String)"list_style", (String)ie.selectList(SymbolFactory.name, "sel1").className());
        SelectboxTest.assertEquals((String)"", (String)ie.selectList(SymbolFactory.name, "sel2").className());
    }

    public void testOptionTextSelect() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "sel1").option(SymbolFactory.text, "missing item").select();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.selectList(SymbolFactory.name, "sel1").option(SymbolFactory.text, "/missing/").select();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.selectList(SymbolFactory.name, "sel1").option(SymbolFactory.id, "Option 1").select();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        ie.selectList(SymbolFactory.name, "sel1").clearSelection();
        ie.selectList(SymbolFactory.name, "sel1").option(SymbolFactory.text, "Option 1").select();
        SelectboxTest.assertEquals((String)"[Option 1]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
    }

    public void testOptionClassName() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "sel1").option(SymbolFactory.text, "missing item").className();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        SelectboxTest.assertEquals((String)"option_style", (String)ie.selectList(SymbolFactory.name, "sel2").option(SymbolFactory.value, "o2").className());
        SelectboxTest.assertEquals((String)"", (String)ie.selectList(SymbolFactory.name, "sel2").option(SymbolFactory.value, "o1").className());
    }

    public void testSelectListGetAllContents() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "NoName").getAllContents();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        SelectboxTest.assertEquals((String)"[Option 1, Option 2, Option 3, Option 4]", (String)ie.selectList(SymbolFactory.name, "sel1").getAllContents().toString());
    }

    public void testSelectListGetSelectedItems() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "NoName").getSelectedItems();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        SelectboxTest.assertEquals((String)"[Option 3]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
        SelectboxTest.assertEquals((String)"[Option 3, Option 6]", (String)ie.selectList(SymbolFactory.name, "sel2").getSelectedItems().toString());
    }

    public void testClearSelection() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "NoName").clearSelection();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        SelectboxTest.assertEquals((String)"[Option 3]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel2").clearSelection();
        SelectboxTest.assertEquals((String)"[]", (String)ie.selectList(SymbolFactory.name, "sel2").getSelectedItems().toString());
    }

    public void testSelectListSelect() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "sel1").select("missing item");
            this.failNoValueFoundException();
        }
        catch (NoValueFoundException e) {
            // empty catch block
        }
        try {
            ie.selectList(SymbolFactory.name, "sel1").select("/missing/");
            this.failNoValueFoundException();
        }
        catch (NoValueFoundException noValueFoundException) {
            // empty catch block
        }
        ie.selectList(SymbolFactory.name, "sel1").clearSelection();
        ie.selectList(SymbolFactory.name, "sel1").select("Option 1");
        SelectboxTest.assertEquals((String)"[Option 1]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel1").clearSelection();
        ie.selectList(SymbolFactory.name, "sel1").select("/2/");
        SelectboxTest.assertEquals((String)"[Option 2]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel2").clearSelection();
        ie.selectList(SymbolFactory.name, "sel2").select("/2/");
        ie.selectList(SymbolFactory.name, "sel2").select("/4/");
        SelectboxTest.assertEquals((String)"[Option 2, Option 4]", (String)ie.selectList(SymbolFactory.name, "sel2").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel3").select("/3/");
        SelectboxTest.assertFalse((boolean)ie.text().contains("PASS"));
    }

    public void testSelectListSelect2() throws Exception {
        ie.selectList(SymbolFactory.name, "sel3").select("/2/");
        SelectboxTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testSelectListSelectUsingValue() throws Exception {
        try {
            ie.selectList(SymbolFactory.name, "NoName").getSelectedItems();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.selectList(SymbolFactory.name, "sel1").selectValue("missing item");
            this.failNoValueFoundException();
        }
        catch (NoValueFoundException e) {
            // empty catch block
        }
        try {
            ie.selectList(SymbolFactory.name, "sel1").selectValue("/missing/");
            this.failNoValueFoundException();
        }
        catch (NoValueFoundException noValueFoundException) {
            // empty catch block
        }
        ie.selectList(SymbolFactory.name, "sel1").clearSelection();
        ie.selectList(SymbolFactory.name, "sel1").selectValue("o1");
        SelectboxTest.assertEquals((String)"[Option 1]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel1").clearSelection();
        ie.selectList(SymbolFactory.name, "sel1").selectValue("/2/");
        SelectboxTest.assertEquals((String)"[Option 2]", (String)ie.selectList(SymbolFactory.name, "sel1").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel2").clearSelection();
        ie.selectList(SymbolFactory.name, "sel2").selectValue("/4/");
        ie.selectList(SymbolFactory.name, "sel2").selectValue("/2/");
        SelectboxTest.assertEquals((String)"[Option 2, Option 4]", (String)ie.selectList(SymbolFactory.name, "sel2").getSelectedItems().toString());
        ie.selectList(SymbolFactory.name, "sel3").selectValue("/3/");
        SelectboxTest.assertFalse((boolean)ie.text().contains("PASS"));
    }

    public void testSelectListSelectUsingValue2() throws Exception {
        ie.selectList(SymbolFactory.name, "sel3").selectValue("/2/");
        SelectboxTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testSelectListProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.selectList(199));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.selectList(199));
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.selectList(199));
        this.assertRaisesUnknownObjectExceptionForMethodDisabled(ie.selectList(199));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.selectList(199));
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.selectList(199));
        SelectboxTest.assertEquals((String)"o3", (String)ie.selectList(0).value());
        SelectboxTest.assertEquals((String)"sel1", (String)ie.selectList(0).name());
        SelectboxTest.assertEquals((String)"", (String)ie.selectList(0).id());
        SelectboxTest.assertEquals((String)"select-one", (String)ie.selectList(0).type());
        SelectboxTest.assertEquals((String)"select-multiple", (String)ie.selectList(1).type());
        ie.selectList(0).select("/1/");
        SelectboxTest.assertEquals((String)"o1", (String)ie.selectList(0).value());
        SelectboxTest.assertFalse((boolean)ie.selectList(0).disabled());
        assert (ie.selectList(3).disabled());
        assert (ie.selectList(SymbolFactory.id, "selectList_4").disabled());
    }

    public void testSelectListIterator() throws Exception {
        SelectboxTest.assertEquals((int)4, (int)ie.selectLists().length());
        SelectboxTest.assertEquals((String)"o3", (String)((SelectList)ie.selectLists().get(0)).value());
        SelectboxTest.assertEquals((String)"sel1", (String)((SelectList)ie.selectLists().get(0)).name());
        SelectboxTest.assertEquals((String)"select-one", (String)((SelectList)ie.selectLists().get(0)).type());
        SelectboxTest.assertEquals((String)"select-multiple", (String)((SelectList)ie.selectLists().get(1)).type());
        int i = 0;
        SelectLists selectLists = ie.selectLists();
        for (SelectList l : selectLists) {
            SelectboxTest.assertEquals((String)ie.selectList(i).name(), (String)l.name());
            SelectboxTest.assertEquals((String)ie.selectList(i).id(), (String)l.id());
            SelectboxTest.assertEquals((String)ie.selectList(i).type(), (String)l.type());
            SelectboxTest.assertEquals((String)ie.selectList(i).value(), (String)l.value());
            ++i;
        }
        SelectboxTest.assertEquals((int)i, (int)ie.selectLists().length());
    }

    public void testOptionsText() throws Exception {
        ie.goTo(HTML_ROOT + "select_tealeaf.html");
        ie.selectList(SymbolFactory.name, "op_numhits").option(SymbolFactory.text, ">=").select();
        SelectboxTest.assertTrue((boolean)ie.selectList(SymbolFactory.name, "op_numhits").option(SymbolFactory.text, ">=").selected());
    }
}

