/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.TextField;
import watij.finders.SymbolFactory;

public class TextAreaFieldsXpathTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "textArea.html");
    }

    public void testTextareaFieldExists() throws Exception {
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine2']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine3']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtReadOnly']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtMultiLine1']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtMultiLine2']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtMultiLine3']").exists());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtReadOnly']").exists());
        TextAreaFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='missing']").exists());
        TextAreaFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine4']").exists());
    }

    public void testTextareaField() throws Exception {
        TextAreaFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']").readOnly());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtReadOnly']").readOnly());
        TextAreaFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtDisabled']").enabled());
        TextAreaFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtMultiLine1']").enabled());
        TextField t1 = ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']");
        TextAreaFieldsXpathTest.assertTrue((boolean)t1.verifyContains("Hello World"));
        TextAreaFieldsXpathTest.assertTrue((boolean)t1.verifyContains("/el/"));
        TextField t2 = ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine2']");
        TextAreaFieldsXpathTest.assertTrue((boolean)t2.verifyContains("/IE/"));
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='NoName']"), "No field to get value of");
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='noID']"), "No field to get value of");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtNone']"), "Some Text");
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtReadOnly']"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtDisabled']"), "Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='missing_field']"), "Some Text");
        ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']").append(" Some Text");
        TextAreaFieldsXpathTest.assertEquals((String)"Hello World Some Text", (String)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']").value());
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtReadOnly']"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtDisabled']"), "Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='missing_field']"), "Some Text");
        ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']").set("watir IE Controller");
        TextAreaFieldsXpathTest.assertEquals((String)"watir IE Controller", (String)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine1']").value());
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@id='txtReadOnly']"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtDisabled']"), "Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='missing_field']"), "Some Text");
        ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine2']").clear();
        TextAreaFieldsXpathTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.xpath, "//TEXTAREA[@name='txtMultiLine2']").value());
    }
}

