/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.finders.SymbolFactory;
import watij.runtime.ObjectDisabledException;

public class TextFieldsXpathTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "textfields1.html");
    }

    public void testTextFieldExists() throws Exception {
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").exists());
        TextFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='missing']").exists());
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@id='text2']").exists());
        TextFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@id='alsomissing']").exists());
    }

    public void testTextFieldVerifyContents() throws Exception {
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").verifyContains("Hello World"));
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").verifyContains("/Hello\\sW/"));
        TextFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").verifyContains("Ruby"));
        TextFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").verifyContains("/R/"));
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.xpath, "//INPUT[@name='NoName']"), "No field to get a value of");
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@id='text2']").verifyContains("goodbye all"));
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.xpath, "/INPUT[@id='noID']"), "No field to get a value of");
    }

    public void testTextFieldEnabled() throws Exception {
        TextFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='disabled']").enabled());
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").enabled());
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@id='text2']").enabled());
    }

    public void testTextFieldReadOnly() throws Exception {
        TextFieldsXpathTest.assertFalse((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='disabled']").readOnly());
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@name='readOnly']").readOnly());
        TextFieldsXpathTest.assertTrue((boolean)ie.textField(SymbolFactory.xpath, "//INPUT[@id='readOnly2']").readOnly());
    }

    public void testTextFieldValue() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.textField(SymbolFactory.xpath, "//INPUT[@name='missing_field']"));
        TextFieldsXpathTest.assertEquals((String)"Hello World", (String)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").value());
    }

    public void testTextFieldAppend() throws Exception {
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//INPUT[@id='readOnly2']"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//INPUT[@name='disabled']"), "Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//INPUT[@name='missing_field']"), "Some Text");
        ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").append(" Some Text");
        TextFieldsXpathTest.assertEquals((String)"Hello World Some Text", (String)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").value());
    }

    public void testTextFieldClear() throws Exception {
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//INPUT[@id='readOnly2']"), "Some Text");
        try {
            ie.textField(SymbolFactory.xpath, "//INPUT[@name='disabled']").set("Some Text");
            this.failObjectDisabledException();
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.textField(SymbolFactory.xpath, "//INPUT[@name='missing_field']"));
        ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").clear();
        TextFieldsXpathTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").value());
    }

    public void testTextFieldSet() throws Exception {
        try {
            ie.textField(SymbolFactory.xpath, "//INPUT[@name='disabled']").set("Some Text");
            this.failObjectDisabledException();
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.textField(SymbolFactory.xpath, "//INPUT[@name='missing_field']"));
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.xpath, "//INPUT[@id='readOnly2']"), "Some Text");
        ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").set("watir IE Controller");
        TextFieldsXpathTest.assertEquals((String)"watir IE Controller", (String)ie.textField(SymbolFactory.xpath, "//INPUT[@name='text1']").value());
    }

    public void testPassword() throws Exception {
        ie.textField(SymbolFactory.xpath, "//INPUT[@name='password1']").set("secret");
        TextFieldsXpathTest.assertEquals((String)"secret", (String)ie.textField(SymbolFactory.xpath, "//INPUT[@name='password1']").value());
        ie.textField(SymbolFactory.xpath, "//INPUT[@id='password1']").set("top_secret");
        TextFieldsXpathTest.assertEquals((String)"top_secret", (String)ie.textField(SymbolFactory.xpath, "//INPUT[@id='password1']").value());
    }
}

