/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.TextField;
import watij.finders.SymbolFactory;

public class TextareaFieldsTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "textArea.html");
    }

    public void testTextareaFieldExists() throws Exception {
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "txtMultiLine1").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "txtMultiLine2").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "txtMultiLine3").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "txtReadOnly").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "txtMultiLine1").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "txtMultiLine2").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "txtMultiLine3").exists());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "txtReadOnly").exists());
        TextareaFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "missing").exists());
        TextareaFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "txtMultiLine4").exists());
    }

    public void testTextareaToString() throws Exception {
    }

    public void testTextareaField() throws Exception {
        TextareaFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "txtMultiLine1").readOnly());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "txtReadOnly").readOnly());
        TextareaFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "txtDisabled").enabled());
        TextareaFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "txtMultiLine1").enabled());
        TextField t1 = ie.textField(SymbolFactory.name, "txtMultiLine1");
        TextareaFieldsTest.assertTrue((boolean)t1.verifyContains("Hello World"));
        TextareaFieldsTest.assertTrue((boolean)t1.verifyContains("/el/"));
        TextField t2 = ie.textField(SymbolFactory.name, "txtMultiLine2");
        TextareaFieldsTest.assertTrue((boolean)t2.verifyContains("/IE/"));
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.name, "NoName"), "No field to get a value of");
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.id, "noID"), "No field to get a value of");
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.name, "txtNone"), "No field to get a value of");
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.name, "NoName"), " Some Text");
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.id, "txtReadOnly"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.name, "txtDisabled"), " Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.name, "missing_field"), "Some Text");
        ie.textField(SymbolFactory.name, "txtMultiLine1").append(" Some Text");
        TextareaFieldsTest.assertEquals((String)"Hello World Some Text", (String)ie.textField(SymbolFactory.name, "txtMultiLine1").getContents());
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.id, "txtReadOnly"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.name, "txtDisabled"), " Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.name, "missing_field"), "Some Text");
        ie.textField(SymbolFactory.name, "txtMultiLine1").set("watir IE Controller");
        TextareaFieldsTest.assertEquals((String)"watir IE Controller", (String)ie.textField(SymbolFactory.name, "txtMultiLine1").getContents());
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.id, "txtReadOnly"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.name, "txtDisabled"), " Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.name, "missing_field"), "Some Text");
        ie.textField(SymbolFactory.name, "txtMultiLine2").clear();
        TextareaFieldsTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.name, "txtMultiLine2").getContents());
    }
}

