/*
 * Decompiled with CFR 0.152.
 */
package watij.finders;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import watij.finders.BaseFinder;
import watij.finders.Finder;
import watij.finders.Symbol;
import watij.utilities.StringUtils;
import watij.utilities.Utils;

public class TextFinder
extends BaseFinder
implements Symbol {
    String what;

    public TextFinder() {
    }

    public TextFinder(String what) {
        this.what = what;
    }

    public Finder newFinder(String what) throws Exception {
        return new TextFinder(what);
    }

    public boolean matches(Element element) throws Exception {
        String elementText = this.innerText(element);
        return Utils.isEmpty(this.what) || !Utils.isEmpty(elementText) && StringUtils.matchesOrEquals(this.what, elementText);
    }

    private String innerText(Element element) {
        StringBuffer sBuf = new StringBuffer();
        this.decendantInnerText(element, sBuf);
        return sBuf.toString();
    }

    private void decendantInnerText(Node node, StringBuffer sBuf) {
        NodeList nodeList = node.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = nodeList.item(i);
            if (child == null || child.getNodeType() != 3) continue;
            sBuf.append(child.getNodeValue());
            this.decendantInnerText(child, sBuf);
        }
    }
}

