/*
 * Decompiled with CFR 0.152.
 */
package watij.runtime.ie;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.Wnd;
import java.io.File;
import java.util.List;
import watij.dialogs.FileDownloadDialog;
import watij.runtime.ie.IE;
import watij.runtime.ie.IEUtil;
import watij.time.Ready;
import watij.time.WaiterImpl;
import watij.utilities.WatijResourceLoader;
import watij.utilities.WatijResources;

public class IEFileDownloadDialog
implements FileDownloadDialog {
    Wnd fileDownloader;
    Wnd fileDownloadSaveAs;
    IE ie;

    public IEFileDownloadDialog(Wnd fileDownloader, Wnd fileDownloadSaveAs, IE ie) {
        this.fileDownloader = fileDownloader;
        this.fileDownloadSaveAs = fileDownloadSaveAs;
        this.ie = ie;
    }

    public static FileDownloadDialog findFileDownloadDialog(IE ie) throws Exception {
        Wnd fileDownloadSaveAs = IEUtil.waitDialogWnd(WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Title_FileDownload), "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Save));
        Wnd fileDownloader = fileDownloadSaveAs.getParent();
        return new IEFileDownloadDialog(fileDownloader, fileDownloadSaveAs, ie);
    }

    public String text() throws Exception {
        return IEUtil.getStaticText(this.fileDownloadSaveAs);
    }

    public String title() throws Exception {
        return this.fileDownloadSaveAs.getWindowText();
    }

    public void quit() throws Exception {
        int wm_quit = 18;
        this.fileDownloadSaveAs.postMessage(wm_quit, 0L, 0L);
    }

    public boolean exists() throws Exception {
        return this.fileDownloader.isWindow();
    }

    public void cancel() throws Exception {
        Wnd wnd = IEUtil.waitDialogWnd(this.fileDownloadSaveAs, "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Cancel));
        IEUtil.clickWindowUntilGone(wnd, this.fileDownloadSaveAs);
    }

    public void open() throws Exception {
        Wnd openButton = IEUtil.waitDialogWnd(this.fileDownloadSaveAs, "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Open));
        IEUtil.clickWindowUntilGone(openButton, this.fileDownloadSaveAs);
    }

    public void closeThisDialogBoxWhenDownloadCompletes(boolean close) throws Exception {
        Wnd checkbox = IEUtil.waitDialogWnd(this.fileDownloader, "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_CloseWhenComplete));
        IEUtil.debugWnd(checkbox, "checkbox");
        int bm_setcheck = 241;
        int bst_checked = 1;
        int bst_unchecked = 0;
        int doClose = close ? bst_checked : bst_unchecked;
        checkbox.sendMessageEx(bm_setcheck, (long)doClose, 0L);
    }

    public void save(String fullPathAndFileName) throws Exception {
        IEUtil.debugWndChildren(this.fileDownloader, "HEHEHHE");
        File file = new File(fullPathAndFileName);
        final Wnd saveButton = IEUtil.waitDialogWnd(this.fileDownloadSaveAs, "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Save));
        new WaiterImpl(10000L, 200L).waitUntil(new Ready(){

            public boolean isReady() throws Exception {
                IEUtil.clickWindow(saveButton);
                return Wnd.findWindow((String)"#32770", (String)WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Title_SaveAs)).isWindow();
            }

            public String getNotReadyReason() {
                return "Could not find 'Save As' dialog";
            }
        });
        Wnd saveAsWnd = IEUtil.waitDialogWnd(WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Title_SaveAs));
        List saveAsWndChildren = saveAsWnd.getChildWindows();
        for (int i = 0; i < saveAsWndChildren.size(); ++i) {
            Wnd saveAsWndChild = (Wnd)saveAsWndChildren.get(i);
            if (!"Edit".equals(saveAsWndChild.getWindowClassName())) continue;
            Function sendMessage = User32.getInstance().getFunction(new FunctionName("SendMessage").toString());
            IntBool result = new IntBool();
            sendMessage.invoke((Parameter)result, (Parameter)saveAsWndChild, (Parameter)new UInt(12L), (Parameter)new BStr(), (Parameter)new BStr(fullPathAndFileName));
            if (file.exists()) {
                file.delete();
            }
            IEUtil.clickWindowUntilGone(IEUtil.waitDialogWnd(saveAsWnd, "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Save)), saveAsWnd);
        }
    }

    public void close() throws Exception {
        if (!this.exists()) {
            throw new Exception("Download Dialog doesn't exist");
        }
        Wnd wnd = IEUtil.waitDialogWnd(this.fileDownloader, "Button", WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Close));
        IEUtil.clickWindowUntilGone(wnd, this.fileDownloader);
    }

    public void waitUntilDownloadComplete() throws Exception {
        new WaiterImpl(999999999L, 200L).waitUntil(new Ready(){

            public boolean isReady() throws Exception {
                if (!IEFileDownloadDialog.this.exists()) {
                    return true;
                }
                Wnd wnd = Wnd.findWindow((String)"#32770", (String)WatijResourceLoader.getString(WatijResources.IEFileDownloadDialog_Title_DownloadComplete));
                IEUtil.debugWnd(wnd, "finding Download complete");
                return wnd.isWindow();
            }

            public String getNotReadyReason() {
                return "Could not find 'Download complete' dialog";
            }
        });
    }
}

