/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.win32.Size;
import java.awt.Rectangle;

public class Rect
extends Structure {
    private LongInt _left = new LongInt();
    private LongInt _top = new LongInt();
    private LongInt _right = new LongInt();
    private LongInt _bottom = new LongInt();

    public Rect() {
        this.init(new Parameter[]{this._left, this._top, this._right, this._bottom});
    }

    public Rect(Rect that) {
        this();
        this.initFrom(that);
    }

    public Rect(long left, long top, long right, long bottom) {
        this();
        this.setLeft(left);
        this.setTop(top);
        this.setRight(right);
        this.setBottom(bottom);
    }

    public Rect(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void setLeft(long value) {
        this._left.setValue(value);
    }

    public long getLeft() {
        return this._left.getValue();
    }

    public void setTop(long value) {
        this._top.setValue(value);
    }

    public long getTop() {
        return this._top.getValue();
    }

    public void setRight(long value) {
        this._right.setValue(value);
    }

    public long getRight() {
        return this._right.getValue();
    }

    public void setBottom(long value) {
        this._bottom.setValue(value);
    }

    public long getBottom() {
        return this._bottom.getValue();
    }

    public void moveTo(long left, long top) {
        long width = this.getWidth();
        long height = this.getHeight();
        this.setLeft(left);
        this.setTop(top);
        this.setRight(left + width);
        this.setBottom(top + height);
    }

    public void moveBy(int deltaX, int deltaY) {
        this.setLeft(this.getTop() + (long)deltaX);
        this.setRight(this.getBottom() + (long)deltaX);
        this.setTop(this.getTop() + (long)deltaY);
        this.setBottom(this.getBottom() + (long)deltaY);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Rect: [").append(this.getLeft()).append(',').append(this.getTop()).append(',').append(this.getRight()).append(',').append(this.getBottom()).append(']');
        return result.toString();
    }

    public Object clone() {
        return new Rect(this);
    }

    public void assign(Rect anotherRect) {
        this.setTop(anotherRect.getTop());
        this.setBottom(anotherRect.getBottom());
        this.setLeft(anotherRect.getLeft());
        this.setRight(anotherRect.getRight());
    }

    public void setBounds(int left, int top, int right, int bottom) {
        this.setTop(top);
        this.setBottom(bottom);
        this.setLeft(left);
        this.setRight(right);
    }

    public void setBounds(Rectangle rectangle) {
        this.setTop(rectangle.y);
        this.setBottom(rectangle.x + rectangle.width);
        this.setLeft(rectangle.x);
        this.setRight(rectangle.y + rectangle.height);
    }

    public int getWidth() {
        return (int)(this._right.getValue() - this._left.getValue());
    }

    public int getHeight() {
        return (int)(this._bottom.getValue() - this._top.getValue());
    }

    public int getLeftAsInt() {
        return (int)this.getLeft();
    }

    public int getTopAsInt() {
        return (int)this.getTop();
    }

    public int getBottomAsInt() {
        return (int)this.getBottom();
    }

    public int getRightAsInt() {
        return (int)this.getRight();
    }

    public Rect centerRect(Size innerRect) {
        int centeredX = (int)this.getLeft() + (this.getWidth() - innerRect.getCx()) / 2;
        int centeredY = (int)this.getTop() + (this.getHeight() - innerRect.getCy()) / 2;
        return new Rect(centeredX, centeredY, centeredX + innerRect.getCx(), centeredY + innerRect.getCy());
    }
}

