/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell.events;

import com.jniwrapper.win32.shell.ShellFolder;
import com.jniwrapper.win32.shell.events.DriveListener;
import com.jniwrapper.win32.shell.events.ShellEvent;
import com.jniwrapper.win32.shell.events.ShellEventsListener;
import com.jniwrapper.win32.shell.events.ShellEventsSubscriber;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DriveEventsSubscriber
extends ShellEventsSubscriber
implements ShellEventsListener {
    private List _driveListeners = Collections.synchronizedList(new LinkedList());

    public DriveEventsSubscriber() {
        this.addShellEventsListener(this);
    }

    public void addDriveListener(DriveListener listener) {
        this._driveListeners.add(listener);
    }

    public void removeDriveListener(DriveListener listener) {
        this._driveListeners.remove(listener);
    }

    public void processEvent(ShellEvent event) {
        int id = event.getId();
        switch (id) {
            case 128: 
            case 256: {
                String path = ShellFolder.getPathFromIDList(event.getItem1());
                Iterator iterator = this._driveListeners.iterator();
                while (iterator.hasNext()) {
                    DriveListener driveListener = (DriveListener)iterator.next();
                    if (id == 256) {
                        driveListener.driveAdded(path);
                        continue;
                    }
                    driveListener.driveRemoved(path);
                }
                break;
            }
        }
    }
}

