package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import watij.elements.Checkbox;
import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.browser.CheckBox;

public class BTCheckBox implements CheckBox {

	Checkbox checkbox;

	BTCheckBox(Checkbox checkbox) {
		this.checkbox = checkbox;
	}

	@Override
	public void check() {
		try {
			this.checkbox.set(true);
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public void unCheck() {
		try {
			this.checkbox.set(false);
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getValue() {
		try {
			return this.checkbox.value();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public boolean isChecked() {
		try {
			return this.checkbox.checked();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getId() {
		try {
			return this.checkbox.id();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getName() {
		try {
			return this.checkbox.name();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public boolean exists() {
		try {
			return this.checkbox.exists();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
