package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.browser.Option;

public class BTOption implements Option {

	watij.elements.Option option;

	BTOption(watij.elements.Option option) {
		this.option = option;
	}

	@Override
	public String getLabel() {
		try {
			return this.option.text();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getValue() {
		try {
			return this.option.value();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public boolean isSelected() {
		try {
			return this.option.selected();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public void select() {
		try {
			this.option.select();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public boolean exists() {
		try {
			return this.option.exists();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getId() {
		try {
			return this.option.id();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getName() {
		try {
			return this.option.name();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
