package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.Target;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

import org.apache.log4j.Logger;

public class DefaultTestCase implements TestCase {

	Logger logger = Logger.getLogger(DefaultTestCase.class);

	private Context context;
	private int testCaseId;
	private CommandEnum command;
	private Target target;
	private String value;

	public DefaultTestCase(Context context,
			int testCaseId, CommandEnum command,
			String targetStream, String value) {
		this.context = context;
		this.testCaseId = testCaseId;
		this.command = command;
		this.target = new DefaultTarget(targetStream);
		this.value = value;
	}

	@Override
	public String toString() {
		return "context=[" + this.context.toString()
				+ "] testCaseId=[" + this.testCaseId
				+ "] command=[" + this.command.toString()
				+ "] target=" + this.target.toString()
				+ " value=" + this.value;
	}
	@Override
	public int getTestCaseId() {
		return this.testCaseId;
	}
	@Override
	public CommandEnum getCommand() {
		return this.command;
	}
	@Override
	public Target getTarget() {
		return this.target;
	}
	@Override
	public String getValue() {
		return this.value;
	}
	@Override
	public void doTest() {
		AbstractInvoker invoker = (AbstractInvoker) this.context.getInvokerFactory().getInvoker(this.command);
		if (this.context.isToolTest()) {
			logger.info("invoke tester:" + invoker.getClass().getName());
		} else {
			invoker.doTest(this);
		}
	}

}
