package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.Anchor;
import jp.sourceforge.cfneo.at4ie2.api.browser.Button;
import jp.sourceforge.cfneo.at4ie2.api.browser.HtmlElement;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class ClickInvoker extends AbstractInvoker {

	public ClickInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		HtmlElement htmlElement = null;
		switch (locatorType) {
		case DOM:
			htmlElement = this.getBrowser().getHtmlElementByDom(testCase.getTarget().getValue());
			break;
		case ID:
			htmlElement = this.getBrowser().getHtmlElement(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			htmlElement = this.getBrowser().getHtmlElement(testCase.getTarget().getValue());
			if (htmlElement.exists() == false) {
				htmlElement = this.getBrowser().getHtmlElementByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			htmlElement = this.getBrowser().getHtmlElementByLink(testCase.getTarget().getValue());
			break;
		case NAME:
			htmlElement = this.getBrowser().getHtmlElementByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			htmlElement = this.getBrowser().getHtmlElementByValue(testCase.getTarget().getValue());
			break;
		case XPATH:
			htmlElement = this.getBrowser().getHtmlElementByXPath(testCase.getTarget().getValue());
			break;
		default:
			;
		}

		if (htmlElement instanceof Button || htmlElement instanceof Anchor) {
			((Button) htmlElement).click();
		}
	}

}
