package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.TextField;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class TypeInvoker extends AbstractInvoker {

	public TypeInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		TextField textField = null;

		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			textField = this.getBrowser().getTextField(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			textField = this.getBrowser().getTextField(testCase.getTarget().getValue());
			if (textField.exists() == false) {
				textField = this.getBrowser().getTextFieldByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			textField = this.getBrowser().getTextFieldByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		textField.setValue(testCase.getValue());
	}

}
