package jp.sourceforge.cfneo.at4ie2;

import static org.junit.Assert.*;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseList;
import jp.sourceforge.cfneo.at4ie2.api.test.TestRunner;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.DefaultContext;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.DefaultTestCaseList;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.DefaultTestRunner;
import jp.sourceforge.cfneo.at4ie2.utils.LocationUtil;

import org.junit.Test;

public class TestRunnerIntegrationTest1 {

	@Test
	public void test() {
		try {
			Context context = DefaultContext.getInstance();
			context.setToolTest(false);
			TestCaseList list = this.createTestCaseList(context);
			TestRunner tr = new DefaultTestRunner(list);
			tr.run();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	private TestCaseList createTestCaseList(Context context) {
		int id = 0;
		TestCaseList list = new DefaultTestCaseList(context);
		list.addTestCase(id++, CommandEnum.OPEN, TestSupport.TARGET_PATH + TestSupport.TARGET_FILE, null);
		list.addTestCase(id++, CommandEnum.ASSERT_LOCATION,
				LocationUtil.convertLocalFilePathToUrlPath(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE), null);
		list.addTestCase(id++, CommandEnum.TYPE, "id=txt0", "abcde");
		list.addTestCase(id++, CommandEnum.CLICK, "id=btn0", null);
		list.addTestCase(id++, CommandEnum.ASSERT_VALUE, "id=txt0", "btn0");
		list.addTestCase(id++, CommandEnum.VERIFY_VALUE, "id=txt0", "btn0_");	
		list.addTestCase(id++, CommandEnum.CLOSE, null, null);
		list.addTestCase(id++, CommandEnum.OPEN, TestSupport.TARGET_PATH + TestSupport.TARGET_FILE, null);
		list.addTestCase(id++, CommandEnum.ASSERT_LOCATION,
				LocationUtil.convertLocalFilePathToUrlPath(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE), null);
		list.addTestCase(id++, CommandEnum.TYPE, "id=txt0", "abcde");
		list.addTestCase(id++, CommandEnum.ASSERT_VALUE, "id=txt0", "abcde");
		list.addTestCase(id++, CommandEnum.CLICK, "id=btn0", null);
		list.addTestCase(id++, CommandEnum.ASSERT_VALUE, "id=txt0", "btn0");
		list.addTestCase(id++, CommandEnum.CLOSE, null, null);
		return list;
	}

}
