package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.cfneo.at4ie2.TestSupport;
import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;

import org.junit.Test;

import watij.finders.SymbolFactory;
import watij.runtime.ie.IE;

public class BTRadioGroupTest {

	@Test
	public void testGetCount() {
		IE ie = new IE();
		Browser browser = new BTInternetExplorer(ie);
		try {
			browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

			BTRadio group = new BTRadio(ie.radios());
			assertEquals(8, group.getCount());

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} finally {
			browser.close();
		}
	}
	@Test
	public void testGetName() {
		IE ie = new IE();
		Browser browser = new BTInternetExplorer(ie);
		try {
			browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

			BTRadio group;

			group= new BTRadio(ie.radios(SymbolFactory.name, "radio1"));
			assertEquals("radio1", group.getName());

			group = new BTRadio(ie.radios(SymbolFactory.name, "radio6"));
			assertEquals("radio6", group.getName());

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} finally {
			browser.close();
		}
	}
	@Test
	public void testGetValue() {
		IE ie = new IE();
		Browser browser = new BTInternetExplorer(ie);
		try {
			browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

			BTRadio group;

			group= new BTRadio(ie.radios(SymbolFactory.name, "radio1"));
			assertEquals(null, group.getName());

			group = new BTRadio(ie.radios(SymbolFactory.name, "radio6"));
			assertEquals("10", group.getName());

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} finally {
			browser.close();
		}
	}
	@Test
	public void testGetIdList() {
		IE ie = new IE();
		Browser browser = new BTInternetExplorer(ie);
		try {
			browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

			BTRadio group;

			List<String> expected;

			expected= new ArrayList<String>();
			expected.add("rd1");
			expected.add("rd2");
			group= new BTRadio(ie.radios(SymbolFactory.name, "radio1"));
			assertEquals(expected, group.getIdList());

			expected= new ArrayList<String>();
			expected.add("rd6");
			expected.add("rd7");
			group = new BTRadio(ie.radios(SymbolFactory.name, "radio6"));
			assertEquals(expected, group.getName());

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} finally {
			browser.close();
		}
	}

}
