package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import static org.junit.Assert.assertEquals;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;

import org.junit.Test;

public class DefaultTargetTest {

	@Test
	public void test_1_identifier() {
		String targetStream = "identifier=aaa";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.IDENTIFIER, dt.getLocatorType());
		assertEquals("aaa", dt.getValue());
	}
	@Test
	public void test_2_id() {
		String targetStream = "id=bbbb";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.ID, dt.getLocatorType());
		assertEquals("bbbb", dt.getValue());
	}
	@Test
	public void test_3_name() {
		String targetStream = "name=cc";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.NAME, dt.getLocatorType());
		assertEquals("cc", dt.getValue());
	}
	@Test
	public void test_4_dom() {
		String targetStream = "dom=document.forms['myForm'].myDropdown";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.DOM, dt.getLocatorType());
		assertEquals("document.forms['myForm'].myDropdown", dt.getValue());
	}
	@Test
	public void test_5_xpath() {
		String targetStream = "xpath=id(\"foo\")/child::para[position()=5]";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.XPATH, dt.getLocatorType());
		assertEquals("id(\"foo\")/child::para[position()=5]", dt.getValue());
	}
	@Test
	public void test_6_link() {
		String targetStream = "link=http://www.google.co.jp/";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.LINK, dt.getLocatorType());
		assertEquals("http://www.google.co.jp/", dt.getValue());
	}
	@Test
	public void test_7_value() {
		String targetStream = "value=\"a=b=c;;;dd\\\"";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.VALUE, dt.getLocatorType());
		assertEquals("\"a=b=c;;;dd\\\"", dt.getValue());
	}
	@Test
	public void test_8_other() {
		String targetStream = "abcde";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.OTHER, dt.getLocatorType());
		assertEquals("abcde", dt.getValue());
	}
	@Test
	public void test_9_other() {
		String targetStream = "a=abcde";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.OTHER, dt.getLocatorType());
		assertEquals("a=abcde", dt.getValue());
	}
	@Test
	public void test_10_other() {
		String targetStream = "";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.OTHER, dt.getLocatorType());
		assertEquals("", dt.getValue());
	}
	@Test
	public void test_11_other() {
		String targetStream = " ";
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.OTHER, dt.getLocatorType());
		assertEquals(" ", dt.getValue());
	}
	@Test
	public void test_12_other() {
		String targetStream = null;
		DefaultTarget dt = new DefaultTarget(targetStream);
		assertEquals(targetStream, dt.getTargetStream());
		assertEquals(LocatorTypeEnum.OTHER, dt.getLocatorType());
		assertEquals(null, dt.getValue());
	}

}
