package jp.sourceforge.cfneo.at4ie2.utils;

import static org.junit.Assert.*;

import org.junit.Test;

public class StringUtilTest {

	@Test
	public void testIsNumeric() {
		fail("Not yet implemented");
	}

	@Test
	public void testIsInteger() {
		fail("Not yet implemented");
	}

	@Test
	public void testIsDouble() {
		fail("Not yet implemented");
	}

	@Test
	public void testIsLocatorFormat() {
		assertTrue(StringUtil.isLocatorFormat("id=aaaa"));
		assertTrue(StringUtil.isLocatorFormat("name=bbbb"));
		assertFalse(StringUtil.isLocatorFormat("ccc"));
		assertFalse(StringUtil.isLocatorFormat("test=dddd"));
		assertFalse(StringUtil.isLocatorFormat(""));
		assertFalse(StringUtil.isLocatorFormat(null));
	}

	@Test
	public void testGetLocatorType() {
		assertEquals("id", StringUtil.getLocatorType("id=aaaa").toString());
		assertEquals("name", StringUtil.getLocatorType("name=bbbb").toString());
		assertEquals("other", StringUtil.getLocatorType("ccc").toString());
		assertEquals("other", StringUtil.getLocatorType("test=dddd").toString());
		assertEquals("other", StringUtil.getLocatorType("").toString());
		assertEquals("other", StringUtil.getLocatorType(null).toString());
	}

	@Test
	public void testGetLocatorValue() {
		assertEquals("aaaa", StringUtil.getLocatorValue("id=aaaa"));
		assertEquals("bbbb", StringUtil.getLocatorValue("name=bbbb"));
		assertEquals("ccc", StringUtil.getLocatorValue("ccc"));
		assertEquals("test=dddd", StringUtil.getLocatorValue("test=dddd"));
		assertEquals("", StringUtil.getLocatorValue(""));
		assertEquals(null, StringUtil.getLocatorValue(null));
	}

	@Test
	public void testSplitComma_1() {
		String[] expected = {"aaa", "bbb", "ccc"};
		String[] actual = StringUtil.splitComma("aaa,bbb,ccc");
		assertEquals(expected.length, actual.length);
		for (int i = 0; i < expected.length; i++) {
			boolean b = false;
			for (int j = 0; j < actual.length; j++) {
				if (expected[i].equals(actual[j])) {
					b = true;
				}
			}
			assertTrue(b);
		}
	}

	@Test
	public void testSplitComma_2() {
		String[] expected = {"aaa", "bbb", "ccc"};
		String[] actual = StringUtil.splitComma("aaa , bbb, ccc");
		assertEquals(expected.length, actual.length);
		for (int i = 0; i < expected.length; i++) {
			boolean b = false;
			for (int j = 0; j < actual.length; j++) {
				if (expected[i].equals(actual[j])) {
					b = true;
				}
			}
			assertTrue(b);
		}
	}

}
