/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Checkbox;
import watij.elements.Checkboxes;
import watij.finders.SymbolFactory;

public class CheckboxTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "checkboxes1.html");
    }

    public void testCheckboxProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.checkbox(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.checkbox(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodDisabled(ie.checkbox(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.checkbox(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.checkbox(SymbolFactory.name, "noName"));
        CheckboxTest.assertEquals((String)"box1", (String)ie.checkbox(0).name());
        CheckboxTest.assertEquals((String)"", (String)ie.checkbox(0).id());
        CheckboxTest.assertEquals((String)"checkbox", (String)ie.checkbox(0).type());
        CheckboxTest.assertEquals((String)"on", (String)ie.checkbox(0).value());
        CheckboxTest.assertEquals((boolean)false, (boolean)ie.checkbox(0).disabled());
        CheckboxTest.assertEquals((String)"check_box_style", (String)ie.checkbox(SymbolFactory.name, "box1").className());
        CheckboxTest.assertEquals((String)"", (String)ie.checkbox(SymbolFactory.name, "box2").className());
        CheckboxTest.assertEquals((String)"1", (String)ie.checkbox(SymbolFactory.name, "box4").value());
        CheckboxTest.assertEquals((String)"3", (String)ie.checkbox(SymbolFactory.name, "box4", 3).value());
        CheckboxTest.assertEquals((String)"checkbox", (String)ie.checkbox(SymbolFactory.name, "box4", 3).type());
        CheckboxTest.assertEquals((boolean)false, (boolean)ie.checkbox(SymbolFactory.name, "box4", 3).disabled());
        CheckboxTest.assertEquals((String)"", (String)ie.checkbox(SymbolFactory.name, "box4", 3).id());
        CheckboxTest.assertEquals((String)"box4-value5", (String)ie.checkbox(SymbolFactory.name, "box4", 5).title());
        CheckboxTest.assertEquals((String)"", (String)ie.checkbox(SymbolFactory.name, "box4", 4).title());
    }

    public void testOnClick() throws Exception {
        CheckboxTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.checkbox(SymbolFactory.name, "box5").set();
        CheckboxTest.assertTrue((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.checkbox(SymbolFactory.name, "box5").clear();
        CheckboxTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
        ie.checkbox(SymbolFactory.name, "box5").clear();
        CheckboxTest.assertFalse((boolean)ie.button(SymbolFactory.value, "foo").enabled());
    }

    public void testCheckboxExists() throws Exception {
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box1").exists());
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "missing").exists());
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box4", 1).exists());
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box4", 22).exists());
    }

    public void testCheckboxEnabled() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.checkbox(SymbolFactory.name, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.checkbox(SymbolFactory.id, "noName"));
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.checkbox(SymbolFactory.name, "box4", 6));
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box1").enabled());
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box2").enabled());
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box4", 4).enabled());
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box4", 5).enabled());
    }

    public void testCheckboxIsSet() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodIsSet(ie.checkbox(SymbolFactory.name, "noName"));
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box1").isSet());
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box2").isSet());
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box3").isSet());
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box4", 2).isSet());
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box4", 1).isSet());
    }

    public void testCheckboxClear() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClear(ie.checkbox(SymbolFactory.name, "noName"));
        ie.checkbox(SymbolFactory.name, "box1").clear();
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box1").isSet());
        this.assertRaisesDisabledObjectExceptionForMethodClear(ie.checkbox(SymbolFactory.name, "box2"));
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box2").isSet());
        ie.checkbox(SymbolFactory.name, "box3").clear();
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box3").isSet());
        ie.checkbox(SymbolFactory.name, "box4", 1).clear();
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box4", 1).isSet());
    }

    public void testCheckboxGetState() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodGetState(ie.checkbox(SymbolFactory.name, "noName"));
        CheckboxTest.assertEquals((boolean)false, (boolean)ie.checkbox(SymbolFactory.name, "box1").getState());
        CheckboxTest.assertEquals((boolean)true, (boolean)ie.checkbox(SymbolFactory.name, "box3").getState());
        CheckboxTest.assertEquals((boolean)false, (boolean)ie.checkbox(SymbolFactory.name, "box4", 2).getState());
        CheckboxTest.assertEquals((boolean)true, (boolean)ie.checkbox(SymbolFactory.name, "box4", 1).getState());
    }

    public void testCheckboxSet() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodSet(ie.checkbox(SymbolFactory.name, "noName"));
        ie.checkbox(SymbolFactory.name, "box1").set();
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box1").isSet());
        this.assertRaisesDisabledObjectExceptionForMethodSet(ie.checkbox(SymbolFactory.name, "box2"));
        ie.checkbox(SymbolFactory.name, "box3").set();
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box3").isSet());
        ie.checkbox(SymbolFactory.name, "box4", 3).set();
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box4", 3).isSet());
        ie.checkbox(SymbolFactory.name, "box1").set(false);
        CheckboxTest.assertFalse((boolean)ie.checkbox(SymbolFactory.name, "box1").isSet());
        ie.checkbox(SymbolFactory.name, "box1").set(true);
        CheckboxTest.assertTrue((boolean)ie.checkbox(SymbolFactory.name, "box1").isSet());
    }

    public void testCheckboxIterator() throws Exception {
        CheckboxTest.assertEquals((int)11, (int)ie.checkboxes().length());
        CheckboxTest.assertEquals((String)"box1", (String)((Checkbox)ie.checkboxes().get(0)).name());
        int i = 0;
        Checkboxes checkboxes = ie.checkboxes();
        for (Checkbox c : checkboxes) {
            CheckboxTest.assertEquals((String)ie.checkbox(i).name(), (String)c.name());
            CheckboxTest.assertEquals((String)ie.checkbox(i).id(), (String)c.id());
            CheckboxTest.assertEquals((String)ie.checkbox(i).value(), (String)c.value());
            ++i;
        }
        CheckboxTest.assertEquals((int)i, (int)checkboxes.length());
    }
}

