/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Label;
import watij.elements.TextField;
import watij.elements.TextFields;
import watij.finders.SymbolFactory;

public class TextFieldsTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "textfields1.html");
    }

    public void testTextFieldExists() throws Exception {
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").exists());
        TextFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "missing").exists());
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "text2").exists());
        TextFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.id, "alsomissing").exists());
    }

    public void testTextFieldVerifyContains() throws Exception {
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains("Hello World"));
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains("/Hello\\sW/"));
        TextFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains("Ruby"));
        TextFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "text1").verifyContains(" / R / "));
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.name, "NoName"), "No field to get a value of");
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "text2").verifyContains("goodbye all"));
        this.assertRaisesUnknownObjectExceptionForMethodVerifyContains(ie.textField(SymbolFactory.id, "noID"), "No field to get a value of");
    }

    public void testTextFieldEnabled() throws Exception {
        TextFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "disabled").enabled());
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "text1").enabled());
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "text2").enabled());
    }

    public void testTextFieldReadonly() throws Exception {
        TextFieldsTest.assertFalse((boolean)ie.textField(SymbolFactory.name, "disabled").readOnly());
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "readOnly").readOnly());
        TextFieldsTest.assertTrue((boolean)ie.textField(SymbolFactory.id, "readOnly2").readOnly());
    }

    public void testTextFieldGetContents() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.textField(SymbolFactory.name, "missing_field"));
        TextFieldsTest.assertEquals((String)"Hello World", (String)ie.textField(SymbolFactory.name, "text1").getContents());
    }

    public void testTextFieldAppend() throws Exception {
        this.assertRaisesObjectReadOnlyExceptionForMethodAppend(ie.textField(SymbolFactory.id, "readOnly2"), "Some Text");
        this.assertRaisesObjectDisabledExceptionForMethodAppend(ie.textField(SymbolFactory.name, "disabled"), "Some Text");
        this.assertRaisesUnknownObjectExceptionForMethodAppend(ie.textField(SymbolFactory.name, "missing_field"), "Some Text");
        ie.textField(SymbolFactory.name, "text1").append(" Some Text");
        TextFieldsTest.assertEquals((String)"Hello World Some Text", (String)ie.textField(SymbolFactory.name, "text1").getContents());
    }

    public void testTextFieldClear() throws Exception {
        ie.textField(SymbolFactory.name, "text1").clear();
        TextFieldsTest.assertEquals((String)"", (String)ie.textField(SymbolFactory.name, "text1").getContents());
    }

    public void testTextFieldSet() throws Exception {
        ie.textField(SymbolFactory.name, "text1").set("watij IE Controller");
        TextFieldsTest.assertEquals((String)"watij IE Controller", (String)ie.textField(SymbolFactory.name, "text1").value());
    }

    public void testTextFieldProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.textField(199));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.textField(199));
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.textField(199));
        this.assertRaisesUnknownObjectExceptionForMethodDisabled(ie.textField(199));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.textField(199));
        TextFieldsTest.assertEquals((String)"Hello World", (String)ie.textField(0).value());
        TextFieldsTest.assertEquals((String)"text", (String)ie.textField(0).type());
        TextFieldsTest.assertEquals((String)"text1", (String)ie.textField(0).name());
        TextFieldsTest.assertEquals((String)"", (String)ie.textField(0).id());
        TextFieldsTest.assertEquals((boolean)false, (boolean)ie.textField(0).disabled());
        TextFieldsTest.assertEquals((String)"", (String)ie.textField(1).name());
        TextFieldsTest.assertEquals((String)"text2", (String)ie.textField(1).id());
        TextFieldsTest.assertTrue((boolean)ie.textField(2).disabled());
        TextFieldsTest.assertEquals((String)"This used to test :afterText", (String)ie.textField(SymbolFactory.name, "aftertest").title());
        TextFieldsTest.assertEquals((String)"", (String)ie.textField(0).title());
    }

    public void testTextFieldIterators() throws Exception {
        int i;
        TextFieldsTest.assertEquals((int)12, (int)ie.textFields().length());
        TextFieldsTest.assertEquals((String)"Hello World", (String)((TextField)ie.textFields().get(0)).value());
        TextFieldsTest.assertEquals((String)"text1", (String)((TextField)ie.textFields().get(0)).name());
        TextFieldsTest.assertEquals((String)"password", (String)((TextField)ie.textFields().get(ie.textFields().length() - 1)).type());
        TextFields textFields = ie.textFields();
        for (i = 0; i < textFields.length(); ++i) {
            TextField t = (TextField)textFields.get(i);
            TextFieldsTest.assertEquals((String)ie.textField(i).value(), (String)t.value());
            TextFieldsTest.assertEquals((String)ie.textField(i).id(), (String)t.id());
            TextFieldsTest.assertEquals((String)ie.textField(i).name(), (String)t.name());
        }
        TextFieldsTest.assertEquals((int)i, (int)ie.textFields().length());
    }

    public void testPassword() throws Exception {
        ie.textField(SymbolFactory.name, "password1").set("secret");
        TextFieldsTest.assertEquals((String)"secret", (String)ie.textField(SymbolFactory.name, "password1").value());
        ie.textField(SymbolFactory.id, "password1").set("top_secret");
        TextFieldsTest.assertEquals((String)"top_secret", (String)ie.textField(SymbolFactory.id, "password1").value());
    }

    public void testLabelsIterator() throws Exception {
        TextFieldsTest.assertEquals((int)3, (int)ie.labels().length());
        TextFieldsTest.assertEquals((String)"Label For this Field", (String)((Label)ie.labels().get(0)).innerText().trim());
        TextFieldsTest.assertEquals((String)"Password With ID ( the text here is a label for it )", (String)((Label)ie.labels().get(2)).innerText());
        int count = 0;
        for (Label l : ie.labels()) {
            ++count;
        }
        TextFieldsTest.assertEquals((int)count, (int)ie.labels().length());
    }

    public void testLabelProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodInnerText(ie.label(20));
        this.assertRaisesUnknownObjectExceptionForMethodFor(ie.label(20));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.label(20));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.label(20));
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.label(20));
        TextFieldsTest.assertFalse((boolean)ie.label(10).exists());
        TextFieldsTest.assertFalse((boolean)ie.label(SymbolFactory.id, "missing").exists());
        TextFieldsTest.assertTrue((boolean)ie.label(0).exists());
        TextFieldsTest.assertEquals((String)"", (String)ie.label(0).id());
        TextFieldsTest.assertFalse((boolean)ie.label(0).disabled());
        TextFieldsTest.assertTrue((boolean)ie.label(0).enabled());
        TextFieldsTest.assertEquals((String)"label2", (String)ie.label(1).id());
        TextFieldsTest.assertEquals((String)"Password With ID ( the text here is a label for it )", (String)ie.label(2).innerText());
        TextFieldsTest.assertEquals((String)"password1", (String)ie.label(2).htmlFor());
    }
}

