/*
 * Decompiled with CFR 0.152.
 */
package watij.finders;

import watij.finders.AttributeFinder;
import watij.finders.Finder;
import watij.finders.IndexFinder;
import watij.finders.TagFinder;
import watij.finders.TextFinder;
import watij.finders.TitleFinder;
import watij.finders.UrlFinder;
import watij.finders.XPathFinder;

public class FinderFactory {
    public static Finder attribute(String name, String value) {
        return new AttributeFinder(name, value);
    }

    public static Finder index(int index) {
        return new IndexFinder(index);
    }

    public static Finder tag(String tagName) {
        return new TagFinder(tagName);
    }

    public static Finder text(String text) {
        return new TextFinder(text);
    }

    public static Finder xpath(String expression) {
        return new XPathFinder(expression);
    }

    public static Finder name(String value) {
        return FinderFactory.attribute("name", value);
    }

    public static Finder url(String value) {
        return new UrlFinder("href", value);
    }

    public static Finder href(String value) {
        return FinderFactory.attribute("href", value);
    }

    public static Finder id(String value) {
        return FinderFactory.attribute("id", value);
    }

    public static Finder value(String value) {
        return FinderFactory.attribute("value", value);
    }

    public static Finder caption(String value) {
        return FinderFactory.attribute("value", value);
    }

    public static Finder title(String value) {
        return new TitleFinder("title", value);
    }

    public static Finder alt(String value) {
        return FinderFactory.attribute("alt", value);
    }

    public static Finder src(String value) {
        return FinderFactory.attribute("src", value);
    }

    public static Finder action(String value) {
        return FinderFactory.attribute("action", value);
    }

    public static Finder method(String value) {
        return FinderFactory.attribute("method", value);
    }
}

