/*
 * Decompiled with CFR 0.152.
 */
package watij.finders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Cell {
    Element webTable;
    List grid;
    Element td;
    int currentRow = 0;
    int currentCol = -1;
    int numRows;
    int numCols;
    int rowIndex;
    int colIndex;

    public Cell(Element td) {
        this.td = this.resolveTd(td);
        this.webTable = this.getParentTable(td);
        this.initTable();
    }

    private Element resolveTd(Element element) {
        if ("th".equalsIgnoreCase(element.getTagName())) {
            return element;
        }
        return this.findAncestorWithTagName(element, "td");
    }

    private void initTable() {
        this.grid = new ArrayList();
        this.numRows = this.getRowCount();
        this.numCols = this.getColumnCount();
        for (int i = 0; i < this.numRows; ++i) {
            this.grid.add(new ArrayList<Object>(Arrays.asList(new Object[this.numCols])));
        }
        Element[] tableRows = this.rows();
        for (int i = 0; i < tableRows.length; ++i) {
            Element tableRow = tableRows[i];
            Element[] tableCells = this.cells(tableRow);
            for (int j = 0; j < tableCells.length; ++j) {
                Element tableCell = tableCells[j];
                this.addCell(tableCell);
            }
        }
    }

    private int getRowCount() {
        return this.webTable.getElementsByTagName("tr").getLength();
    }

    private Element[] rows() {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = this.webTable.getElementsByTagName("tr");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
        return list.toArray(new Element[0]);
    }

    private void addCell(Element tableCell) {
        this.findNextAvailableRowAndColumn();
        List columns = (List)this.grid.get(this.currentRow);
        columns.set(this.currentCol, tableCell);
        if (tableCell == this.td) {
            this.colIndex = this.currentCol;
            this.rowIndex = this.currentRow;
        }
        int rowspan = this.rowspan(tableCell);
        int colspan = this.colspan(tableCell);
        for (int i = 0; i < rowspan; ++i) {
            int j;
            int n = j = i == 0 ? 1 : 0;
            while (j < colspan) {
                ((List)this.grid.get(this.currentRow + i)).set(this.currentCol + j, new TableSpan(tableCell));
                ++j;
            }
        }
    }

    private void findNextAvailableRowAndColumn() {
        while (this.currentRow < this.grid.size()) {
            while (this.currentCol < this.numCols - 1) {
                ++this.currentCol;
                List columns = (List)this.grid.get(this.currentRow);
                Object component = columns.get(this.currentCol);
                if (component instanceof TableSpan) continue;
                return;
            }
            this.currentCol = -1;
            ++this.currentRow;
        }
    }

    public List above() {
        ArrayList list = new ArrayList();
        for (int i = this.rowIndex; i >= 0; --i) {
            List columns = (List)this.grid.get(i);
            Object o = columns.get(this.colIndex);
            if (o instanceof TableSpan) {
                o = ((TableSpan)o).getTableCell();
            }
            if (list.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    public List below() {
        ArrayList list = new ArrayList();
        for (int i = this.rowIndex; i < this.numRows; ++i) {
            List columns = (List)this.grid.get(i);
            Object o = columns.get(this.colIndex);
            if (o instanceof TableSpan) {
                o = ((TableSpan)o).getTableCell();
            }
            if (list.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    public List right() {
        ArrayList list = new ArrayList();
        for (int i = this.colIndex; i < this.numCols; ++i) {
            List columns = (List)this.grid.get(this.rowIndex);
            Object o = columns.get(i);
            if (o instanceof TableSpan) {
                o = ((TableSpan)o).getTableCell();
            }
            if (list.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    public List left() {
        ArrayList list = new ArrayList();
        for (int i = this.colIndex; i >= 0; --i) {
            List columns = (List)this.grid.get(this.rowIndex);
            Object o = columns.get(i);
            if (o instanceof TableSpan) {
                o = ((TableSpan)o).getTableCell();
            }
            if (list.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    private int getColumnCount() {
        Element[] rows = this.rows();
        int maxCount = 0;
        for (int i = 0; i < rows.length; ++i) {
            Element row = rows[i];
            Element[] cells = this.cells(row);
            int columnCount = 0;
            for (int j = 0; j < cells.length; ++j) {
                Element cell = cells[j];
                columnCount += this.colspan(cell);
            }
            if (columnCount <= maxCount) continue;
            maxCount = columnCount;
        }
        return maxCount;
    }

    private int colspan(Element element) {
        try {
            return new Integer(element.getAttribute("colspan"));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private int rowspan(Element element) {
        try {
            return new Integer(element.getAttribute("rowspan"));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private Element[] cells(Element element) {
        int i;
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = element.getElementsByTagName("td");
        for (i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
        nodeList = element.getElementsByTagName("th");
        for (i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
        return list.toArray(new Element[0]);
    }

    protected Element getParentTable(Element element) {
        return this.findAncestorWithTagName(element, "table");
    }

    protected Element findAncestorWithTagName(Node node, String tagName) {
        while (node != null && !tagName.equalsIgnoreCase(node.getNodeName())) {
            node = node.getParentNode();
        }
        return (Element)node;
    }

    private class TableSpan {
        Element tableCell;

        public TableSpan(Element tableCell) {
            this.tableCell = tableCell;
        }

        public Element getTableCell() {
            return this.tableCell;
        }
    }
}

