package jp.sourceforge.cfneo.at4ie2.api.browser;

import java.util.List;

public interface Browser {

	/*
	 * uEUւ̑B
	 */
	public void open(String url);
	public void goTo(String url);
	public void close();
	public void saveScreenShot(String filepath);
	public void clickBrowserBack();
	public void clickBrowserNext();

	/*
	 * uEȔB
	 */
	public int getBrowserId();
	public boolean isOpened();
	public String getTitle();
	public String getUrl();
	public int getChildBrowserCount();
	public Browser getChildeBrowser(int index);

	/*
	 * |bvAbvR|[lgւ̃ANZXB
	 */
	public AlertDialog getAlertDialog();
	public ConfirmDialog getConfirmDialog();

	/*
	 * UIR|[lgւ̃ANZXB
	 */
	// htmlelement
	public HtmlElement getHtmlElement(String id);
	public HtmlElement getHtmlElementByName(String name);
	public HtmlElement getHtmlElementByDom(String dom);
	public HtmlElement getHtmlElementByXPath(String xpath);
	public HtmlElement getHtmlElementByLink(String url);
	public HtmlElement getHtmlElementByValue(String value);
	// htmlelement for data input
	public HtmlDataComponent getHtmlDataComponent(String id);
	public HtmlDataComponent gethtmlDataComponentByName(String name);
	// input:text
	public TextField getTextField(String id);
	public TextField getTextFieldByName(String name);
	// input:button
	public Button getButton(String id);
	public Button getButtonByName(String name);
	public Button getButtonByValue(String value);
	// a:href
	public Anchor getAnchor(String id);
	public Anchor getAnchorByName(String name);
	public Anchor getAnchorByUrl(String url);
	public Anchor getAnchorByLabel(String label);
	// span
	public Span getSpan(String id);
	public Span getSpanByName(String name);
	// hidden
	public Hidden getHidden(String id);
	public Hidden getHiddenByName(String name);
	// select
	public Select getSelect(String id);
	public Select getSelectByName(String name);
	// input:radio
	public Radio getRadioByName(String name);
	// input:checkbox
	public CheckBox getCheckBox(String id);
	public CheckBox getCheckBoxByName(String name);
	public List<CheckBox> getCheckBoxListByName(String name);
	public List<CheckBox> getCheckedCheckBoxByName(String name);

}
