package jp.sourceforge.cfneo.at4ie2.api.test;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.utils.StringUtil;

public class BTAssertException extends BTRuntimeError {

	private static final long serialVersionUID = 1L;

	public BTAssertException(String errorMessage) {
		super(errorMessage);
	}
	public BTAssertException(String expected, String actual) {
		super("Test result unmatch. expected=[" + expected + "]/actual=[" + actual + "]");
	}
	public BTAssertException(String[] expected, String[] actual) {
		super("Test result unmatch. expected=[" + StringUtil.createLine(expected) + "]/actual=[" + StringUtil.createLine(actual) + "]");
	}
	public BTAssertException(int expected, int actual) {
		this(String.valueOf(expected), String.valueOf(actual));
	}
	public BTAssertException(Exception e) {
		super(e);
	}

}
