package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class AssertAlertInvoker extends AbstractInvoker {

	public AssertAlertInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		if (this.getBrowser().getAlertDialog().exists() == false) {
			throw new BTAssertException("Target is not found.");
		}
		String expected = testCase.getTarget().getTargetStream();
		String actual = this.getBrowser().getAlertDialog().getLabel();
		if (expected.equals(actual) == false) {
			throw new BTAssertException(expected, actual);
		}
	}

}
