package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.Select;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class SelectInvoker extends AbstractInvoker {

	public SelectInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		Select select = null;
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			select = this.getBrowser().getSelect(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			select = this.getBrowser().getSelect(testCase.getTarget().getValue());
			if (select.exists() == false) {
				select = this.getBrowser().getSelectByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			select = this.getBrowser().getSelectByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		select.getOptionByLabel(testCase.getValue()).select();
	}

}
