package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie2.TestSupport;
import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;
import jp.sourceforge.cfneo.at4ie2.utils.LocationUtil;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import watij.runtime.ie.IE;

public class BTInternetExplorerTest1 {

	Browser browser;

	@Before
	public void before() {
		browser = null;
	}

	@After
	public void after() {
		if (browser != null) {
			browser.close();
		}
	}

	@Test
	public void testBTInternetExplorer() {
		try {
			new BTInternetExplorer();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void testBTInternetExplorerIE() {
		try {
			IE ie = new IE();
			new BTInternetExplorer(ie);
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	public void testSendKey() {
		fail("Not yet implemented"); // TODO
	}
	@Test
	public void testOpen() {
		try {
			browser = new BTInternetExplorer();
			browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);
			assertTrue(browser.isOpened());
			browser.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	@Test
	public void testGoTo() {
		try {
			browser = new BTInternetExplorer();
			String path;
			path = TestSupport.TARGET_PATH + TestSupport.TARGET_FILE;
			browser.open(path);
			assertEquals("file:///" + LocationUtil.convertLocalFilePathToUrlPath(path), browser.getUrl());
			path = TestSupport.TARGET_PATH + "\\watijitest_popup.html";
			browser.goTo(path);
			assertEquals("file:///" + path, browser.getUrl());
			browser.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void testClose() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testSaveScreenShot() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testClickBrowserBack() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testClickBrowserNext() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testIsOpened() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetTitle() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetChildBrowserCount() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetChildeBrowser() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetAlertDialog() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetConfirmDialog() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetTextField() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetTextFieldByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetButton() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetButtonByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetButtonByValue() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetAnchor() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetAnchorByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetAnchorByUrl() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetAnchorByLabel() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetSpan() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetSpanByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetHidden() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetHiddenByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetSelect() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetSelectByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetRadioByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetCheckBox() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetCheckBoxByName() {
		fail("Not yet implemented"); // TODO
	}

	@Test
	public void testGetCheckedCheckBox() {
		fail("Not yet implemented"); // TODO
	}

}
