/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2006 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#pragma once

#include "coord.h"

//`惂[h iȉ̒l̘_aƂĎgj
#define DRAW_ON		1	// ʏ̕`
#define DRAW_OFF	2	// B炭͔wiFł̕`w
#define DRAW_TEMP	4	// XOR[hł̕`
#define DRAW_FAST	8	// [hł̕`B炭͎̂悤Ȃ́j
						//		EiȂsԍAsAiԍAiȗ
						//		E^OȂ當ȗ
						//	 ̑̑̐}ʗvfł͂̃rbg͈ӖȂ
#define DRAW_INVERT	16	// BSch8hbgXORŗLBiԍAi̕`Ŏgp
#define DRAW_PARTFRAME 		32	//ig̕`
#define DRAW_DARK	64	// ÂFł̕`
#define DRAW_INH_PARTNAME 	256	//i̕`Ȃ
#define DRAW_INH_PARTNUM  	512	//iԍ̕`Ȃ
#define DRAW_INH_PARTBODY  1024	//i{fB̕`Ȃ

///////////////////////////////////////////////////////////////
// F
#define COL_JUNC			(RGB(  0,255,  0))
#define COL_WIRE			(RGB(  0,255,  0))
#define COL_BUS				(RGB(  0,255,255))
#define COL_DASH			(RGB(255,255,  0))
#define COL_TAG				(RGB(255,255,  0))
#define COL_TAG_NAME		(RGB(  0,255,255))
#define COL_COMMENT			(RGB(  0,255,255))
#define COL_LABEL			(RGB(  0,255,  0))
#define COL_XOR				(RGB(255,  0,  0))
#define COL_PART			(RGB(  0,128,  0))
#define COL_PART_PINNAME	(RGB(  0,  0,255))	
#define COL_PART_PINNUM		(RGB(128,  0,128))
#define COL_PART_NAME		(RGB(255,255,255))	
#define COL_PART_NUM		(RGB(255,255,255))
#define COL_PART_FRAME		(RGB(  0,  0,255))
#define COL_SHEET_FRAME		(RGB(255,255,  0))
#define COL_SHEET_GRID		(RGB(255,  0,  0))
#define COL_DARK			(RGB(220,220,220))
#define COL_EDITPTN			(RGB(  0,128,255))
#define COL_OFF				(RGB(  0,  0,  0))

class SPtnObjLine;
class SPtnObjCircle;
class SPtnObjPolygon;
class SPtnObjArc;
class SPtnObjText;

extern bool g_bIsWin9x;

//p^[Line̕`
void g_DrawPtnLine(
			CDC* pDC,				//`
			SPtnObjLine* pObj,		//`IuWFNg
			COLORREF col,			//`F
			int	 dir,
			int	 cx,
			int  cy,
			int	 x0,
			int  y0,
			int  nVExt,				//\{(View)
			int  nWExt)				//\{(Window)
;

//p^[Circle̕`
void g_DrawPtnCircle(
			CDC* pDC,				//`
			SPtnObjCircle* pObj,	//`IuWFNg
			COLORREF col,			//`F
			int	 dir,
			int	 cx,
			int  cy,
			int	 x0,
			int  y0,
			int  nVExt,				//\{(View)
			int  nWExt)				//\{(Window)
;

void g_DrawPtnPolygon(
			CDC* pDC,				//`
			SPtnObjPolygon* pObj,	//`IuWFNg
			COLORREF col,			//`F
			int	 dir,
			int	 cx,
			int  cy,
			int	 x0,
			int  y0,
			int  nVExt,				//\{(View)
			int  nWExt)				//\{(Window)
;

void g_DrawPtnArc(
			CDC* pDC,				//`
			SPtnObjArc* pObj,		//`IuWFNg
			COLORREF col,			//`F
			int	 dir,
			int	 cx,
			int  cy,
			int	 x0,
			int  y0,
			int  nVExt,				//\{(View)
			int  nWExt)				//\{(Window)
;

void g_DrawPtnText(
			CDC* pDC,				//`
			SPtnObjText* pObj,		//`IuWFNg
			COLORREF col,			//`F
			int	 dir,
			int	 cx,
			int  cy,
			int	 x0,
			int  y0,
			int  nVExt,				//\{(View)
			int  nWExt)				//\{(Window)
;

void g_drawComponentPin(
	CDC* pDC,						//`
	const SPoint& pinPos,
	int	pinType,
	int nLtrb,
	LPCSTR pszPinName,				//s
	LPCSTR pszPinNum,				//sԍ
	DWORD dwMode,					//`惂[h
	int nVExt,						//\{(View)
	int nWExt,						//\{(Window)
	LPCRECT lprcClip)				//Nbv
;

