/****************************************************************************
    NL3W netlist utility for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef XBSCHDOC_H
#define XBSCHDOC_H


#include <list>
using namespace std;

#include "xbschobj.h"
#include "ce3io.h"

//typedef list<string> stringList;
//typedef list<string>::iterator stringListIterator;

typedef list<SXBSchObj*> XBSchObjList;
typedef list<SXBSchObj*>::iterator XBSchObjListIterator;


class SXBSchSheetInfo;
class SXBSchWire;



class SXBSchDoc
{
public:
	SXBSchDoc();
	virtual ~SXBSchDoc();


protected:
	bool m_bDirty;		//hLgɑ΂ĕύXƂtrueɂȂB
	SSize m_sizeSheet;	//V[g̃TCYۑ
	int m_nOpCount;				//ԍ
	int m_nOldestOpCount;		//ƂÂԍ
	SRect m_rcTempArea;			//	
	SRect m_rcRotateRect;		//]┽]ŒSʒu߂邽߂̃GA
	SPoint m_ptTempSnapPoint;	//ꎞIuWFNgXibvꍇ͂̓_Obhɏ悤ɂ
	bool m_bSelectForDrag;
	unsigned m_visibleLayer;
	int m_editLayer;



protected:
	//Ỉ bDel  true ̂Ƃ́A폜s
	//public  resetSelect()  del() Ă΂B
	//hLgɕύXƂtrueԂ
	bool resetSelect_1(bool bDel=false);

	void pickupJunction(const SRect& rc);//ׂĂ̐ڍ_ m_listWorkJunc ɒoB
	void selectForDragJunction(int scanMax,const SRect& rc);	//͈͓̐ڍ_̑IBׂĂ̐ڍ_m_listWorkJunc ɒoB
	int divideWire(SXBSchWire* swire,const SRect& rc,SXBSchWire** dwire);
	void selectForDragWire(int scanMax,const SRect& rc);		//hbÔ߂̃C[IB
	void selectForDragExceptJuncWire(int scanMax,const SRect& rc);//hbÔ߂̐ڍ_C[ȊȎIB
	
	

public:  //Xg[I/O֘A
	bool writeMinimumLb3(SWriteCE3& wce3,XBSchObjList* pList,bool bOwnOnly);
	bool writeCe3(SWriteCE3& wce3,XBSchObjList* pList,bool bAllObj,const SPoint* pptOrigin);
	bool readCe3(SReadCE3& rce3,XBSchObjList* pList,const SPoint* pptOrigin,SXBSchSheetInfo* pSheetInfo);



public:
	XBSchObjList m_listMain;
	XBSchObjList m_listTemp;
protected:
	XBSchObjList m_listWorkJunc;	//ꎞƗp̃[NGA hbOIŎgp
	XBSchObjList m_listWorkWire;	//ꎞƗp̃[NGA hbOIŎgp


public:
	bool isDirty(){return m_bDirty;}	//Ō̕ۑ̂ƂɕύXǂԂ
	bool isEmpty();	//}ʃIuWFNgłfalseԂ
	void SetSheetSize(const SSize& size);
	SSize SheetSize(){return m_sizeSheet;}



public:
	//}ʗvf̒ǉ ԍԂ
	int add(SXBSchObj* pObj);
	//IԂŒǉ}ʗvf̒ǉ ԍԂ
	int addSelect(SXBSchObj* pObj);
	//_w肵Ă̑I
	int select(const SPoint& pt);
	//͈͂w肵Ă̑I
	int select(const SRect& rc);
	int selectForDrag(const SRect& rc);



	//m_rcTempArea  m_ptTempSnapPoint ꎞIuWFNg̃Xgݒ肷B
	void setupRcTempArea();
	void setupRotateRect();

	
	
	//Ỉ
	//hLgɕύXƂtrueԂ
	bool resetSelect();
	//ꎞIuWFNg͈̔͂擾
	SRect tempArea(){return m_rcTempArea;}
	//ꎞIuWFNg̃Xibv|Cg擾
	SPoint tempSnapPoint(){return m_ptTempSnapPoint;}
	//
	void init();
	//t@C̓ǂݍ
	int readFile(const char* fname);
	int readFile(FILE* fp);
	//t@Cւ̏
	int writeFile(const char* fname);
	int writeFile(FILE* fp);




	//***** ҏW *****

	//Rs[
	//Rs[sꂽƂtrueԂ
	virtual bool copy(){return false;}
	//\t
	//hLgɕύXƂtrueԂ
	virtual bool paste(const SPoint&){return false;}
	//\t\H
	virtual bool canPaste(){return false;}

	//폜
	//hLgɕύXƂtrueԂ
	bool del();

	//؂
	//hLgɕύXƂtrueԂ
	bool cut();


	//Undo
	//hLgɕύXƂtrueԂ
	bool undo();

	//Rs[\H
	bool canCopy();
	//폜\H
	bool canDel();
	//؂\H
	bool canCut();
	//Undo\H
	bool canUndo();

	//AttributeύX\?
	bool canAttribute();

	//Rotate
	//hLgɕύXƂtrueԂ
	bool rotate();
	//Mirror
	//hLgɕύXƂtrueԂ
	bool mirror();

	//Rotate\H
	bool canRotate();
	//Mirror\H
	bool canMirror();
	

	//C[̈ړ
	bool moveToLayer(int nLayer);


	//ԍԂ
	int opCount(){return m_nOpCount;}
	//Âf[^̍폜
	void delOldData(int nOpCount);
	//w肵Wꎞf[^̏ォǂ
	int isOnTempData(const SPoint& pt);
	//ꎞf[^ړ
	void moveTempData(int offsetx,int offsety);
};

#endif  //#ifndef XBSCHDOC_H
